#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/requires/require_the_project.rb'
# =========================================================================== #
require 'colours/project/project.rb'
require 'colours/requires/require_the_constants.rb'
require 'colours/requires/require_commandline.rb'
require 'colours/html_colours/html_colours.rb'
require 'colours/class/colours.rb'
require 'colours/requires/require_rgb.rb'
require 'colours/requires/require_the_toplevel_methods.rb'
require 'colours/requires/require_the_256_colours_module.rb'
# =========================================================================== #
# Load up the testing-relevant code:
# =========================================================================== #
require 'colours/testing/testing.rb'
require 'colours/version/version.rb'
require 'colours/requires/require_eparse.rb'
# =========================================================================== #
# Next require the html-colours components of the colours project:
# =========================================================================== #
require 'colours/requires/require_the_html_colours.rb'

# =========================================================================== #
# Next require the colour-methods - these include Colours.sfancy(),
# Colours.sdir() and so forth:
# =========================================================================== #
require 'colours/requires/require_the_colour_methods.rb'

require 'colours/requires/require_the_kde_colour_palette.rb'

# =========================================================================== #
# Next, add the submodule at "Colours::E":
# =========================================================================== #
require 'colours/e/e.rb'

# =========================================================================== #
# Require the big "symbol-mapper" next:
# =========================================================================== #
require 'colours/map_symbol_to_corresponding_colour/map_symbol_to_corresponding_colour.rb'

require 'colours/replace_tokens_with_colour_code/replace_tokens_with_colour_code.rb'

# =========================================================================== #
# Requiring the autogenerated methods may not be what the user wants to
# have. For instance, the 256-colours module is only relevant if the user
# makes use of these methods, which is most likely not the default
# case.
# =========================================================================== #
# require 'colours/requires/require_autogenerated_colour_methods.rb'
# =========================================================================== #

require 'colours/html_colours/push_the_html_colours_methods_onto_the_toplevel_namespace.rb'