#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Add the test() method to the Colours module here.
# =========================================================================== #
# require 'colours/testing/testing.rb'
# =========================================================================== #
module Colours

  require 'colours/toplevel_methods/e.rb'
  require 'colours/toplevel_methods/toplevel_methods.rb'

  # ========================================================================= #
  # === Colours.simple_colours_test
  #
  # This method purposely tests only the basic parts for colours-related
  # output onto the terminal.
  # ========================================================================= #
  def self.simple_colours_test
    show_basic_colour_palette
  end

  # ========================================================================= #
  # === Colours.test
  #
  # This class-method can be used to test the Colours module.
  #
  # It will be called from the test.rb file, in order to test all components
  # of the Colours module.
  #
  # To invoke it, do:
  #
  #   Colours.test
  #
  # ========================================================================= #
  def self.test
    require 'colours/basic_colours/basic_colours.rb'
    require 'colours/colour_table/colour_table.rb'
    cliner
    show_basic_colour_palette
    cliner
    e red('Hello ')+cyan('World!')
    e 'Hi '+Colours.red+'there.'+rev
    e 'Hi '+Colours.cyan+'there.'+rev
    e 'Hi '+Colours::BasicColours.bold_white+'there.'+rev
    e 'Hi '+Colours.pink+'there.'+rev
    e 'Hi '+Colours.brown+'there.'+rev
    cliner
    e CYAN+'Hi there.'
    e BWHITE+'Hi there.'+BBLUE+' Yo there.'+rev
    e sfancy('yo')+simp(' there')
    disable_colours(true)
    e sfancy('yo')+simp(' there')
    enable_colours(true)
    e sfancy('yo')+simp(' there')
    e rgb_to_hex('155255255')
    e col '/Depot/Audio'
    e col '/Depot/Audio/Westbam_Sunshine.mp3'
    e rev+'This is '+simp('elegant => simportant()')+'.'
    e rev+'This is '+sfancy('elegant => sfancy()')+'.'
    e rev+'This is '+sdir('elegant => sdir()')+'.'
    e rev+'This is '+sfile('elegant => sfancy()')+'.'
    e rev+'This is '+swarn('elegant => swarn()')+'.'
    e rev+'This is '+ssym('elegant => ssym()')+'.'
    ecomment 'An this # could be a comment.'
    e
    e 'Changing colour codes now. We should see different colours '+
      'when compared to the above.'
    e
    ::Colours.update_the_colour_codes_with
    e rev+'This is '+simportant('elegant => simportant()')+'.'
    e rev+'This is '+sfancy('elegant => sfancy()')+'.'
    e rev+'This is '+sdir('elegant => sdir()')+'.'
    e rev+'This is '+sfile('elegant => sfancy()')+'.'
    e rev+'This is '+swarn('elegant => swarn()')+'.'
    e rev+'This is '+ssym('elegant => ssym()')+'.'
    e 'Do we use colours? '+use_colours?.to_s
    e cyan+' ==> Hi there.'
    e red+' ==> Hi there.'
    e green+' ==> Hi there.'
    e brown+' ==> Hi there.'
    e blue+' ==> Hi there.'
    e teal+' ==> Hi there.'
    e white+' ==> Hi there.'
    e grey+' ==> Hi there.'
    e lightblue+' ==> Hi there.'+red()+' yo'
    e RED+'This is red galore.'
    e 'right?'+::Colours.rev
    e BLUE+'This is blue now.'
    e 'right?'+rev
    e 'Hi there - this should be white.'
    # html_colours?
    p main_colours
    main_colours.each {|entry|
      send(entry, 'test')
    }
    e 'yo this should '+pink('be pink.')
    puts CFANCY+' Hi there.'
    puts CIMPORTANT+' Hi there.'
    # Next, we will disable the colours.
    disable_colours(true)
    # The following ones have a newline.
    e rev+'This is '+simportant('elegant => simportant().',true)
    e rev+'This is '+sfancy('elegant => sfancy().',true)
    e rev+'This is '+sdir('elegant => sdir().',true)
    e rev+'This is '+sfile('elegant => sfancy().',true)
    ::Colours.enable_colours(true)
    e rev+'This is '+simportant('elegant => simportant()')+'.'
    e rev+'This is '+sfancy('elegant => sfancy()')+'.'
    e rev+'This is '+sdir('elegant => sdir()')+'.'
    e rev+'This is '+sfile('elegant => sfancy()')+'.'; e
    e 'Next, trying to underline:'
    underline 'Hi there'
    e 'Next trying eparse:'
    eparse 'Joe: Hey Tim, how do you do?'
    eparse 'Tim: Really fine. How about you?'
    eparse '   Joe: ok man let us proceed'
    eparse '  [name of character here] # show when this character last logged in'
    e
    e 'Next some tests with col():'
    e
    e '  '+col('/Depot/Audio/AVAILABLE_SONGS').to_s
    e '  '+col('/Depot/Audio').to_s
    e
    cliner
    e 'Now testing Colours.red("foobar"):'
    e red('foobar')
    e 'Next, we test Colours.enable() and Colours.disable()'
    disable
    e 'Colours.disable()'
    e rev+'This is '+simportant('elegant => simportant()')+'.'
    e 'Colours.enable()'
    enable
    e rev+'This is '+simportant('elegant => simportant()')+'.'
    e rev+'The colour for symlinks is: '+simportant('Colours.colour_for_symlinks')
    pp colour_for_symlinks
    e rev+'A classical Hello World! example, and the colour-code for it.'
    efancy 'Hello World!'
    pp sfancy('Hello World!')
    e 'Next removing some escape sequences:'
    e
    e remove_escape_sequences("  \e[1;31mhello world\e[0;0m # <-- "+
      "This here is not coloured and it also does not have "+
      "escape-sequences either.")
    e
    e 'Next testing whether Colours.yellow() works:'
    e
    e "  hello #{Colours.yellow('world!')}#{rev}"
    e
    e 'Next testing Colours.eparse():'
    e
    eparse '  hello # world!'
    e
    e 'Next testing Colours.ecomment():'
    e
    ecomment '  hello # world!'
    e
  end

end

if __FILE__ == $PROGRAM_NAME
  include Colours
  ::Colours.test
end # Colours.test