#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'colours/autoinclude'

class Bar
  include Colours
end

N = "\n"
e 'Now testing the gem called '+sfancy('colours')+rev+'.'
e
e 'We will also read in this html file lateron:'
e
e '  '+sfile(Colours::TEST_FILE)

# =========================================================================== #
# === konsole_colour_tests
# =========================================================================== #
def konsole_colour_tests(i = ARGV)
  e 'First, we will display six random colours.'
  e
  e Colours[:random]+' heya1'
  e Colours[:random]+' heya2'
  e Colours[:random]+' heya3'
  e Colours.random(' heya4')
  e Colours.random(' heya5')
  e Colours.random(' heya6')
  pp Colours[:slateblue]
  _ = Colours::Colour.new(ARGV)
  begin
    _.show_in_random_colour 'hmm'+N
    _.show_in_random_colour 'hmm'+N
    _.show_in_random_colour 'hmm'+N
  rescue; end
  # p _.html_colours # Test outputting all HTML colours.
  # p Colours.html_colours
  # p _.rvalue
  _.seed_rgb_values # Get some random values for R,G,B.
  # _.output_this_string :default, 89, 250, 237
  _.output_this
  _.output_this 'Hello World!'+N, :random_colours
  _.output_this "Hello World!\n", :random_colours
  _.output_this :random_colours
  e _.random_colour? 'yeah'
  # _.slateblue
  # _.slateblue 'Hello World!'+N+N+N+N
  # _.slateblue 'yoo!'+N
  # e _.slateblue+'Direct test 1'
  # e _.lightcyan+'Direct test 2'
  # e _.mintcream+'Direct test 3'
  # e _.slateblue('Direct test 4')
  begin
  e '
  This is a longer paragraph. Some '+_.slateblue(:keywords)+' will
  be highlighted in '+_.random_colour('a colour')+'.'+N+N+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+N+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')+
  ' '+_.random_colour('test')
  e
  rescue; end
  e 'Next trying to find out whether slateblue is registered or not:'
  e _.registered_colour? 'slateblue'
  e 'Next trying to read in a file:'
  Colours.cliner {
    _.read_file(TEST_FILE)
  }
  Colours.cliner {
    e 'The registered colours are (Colours.registered_colours? '+
      '- showing only 5):'
    pp Colours.registered_colours?[0..5]
  }
  e
  e 'Next we will show some random colours, just to test whether this'
  e 'functionaly works properly:'
  e
  e '  '+Colours.random_colour?
  e '  '+Colours.random_colour?
  e '  '+Colours.random_colour?
  e '  '+Colours.random_colour?
  e '  '+Colours.random_colour?
  e '  '+Colours.random_colour?
  e
  e "Next testing Colours :green, 'hello world'"
  konsole_colours :green, 'hello world'
  Colours.cliner {
    e Time.now.strftime('%H:%M:%S')
    puts kde_colour(:slateblue, Time.now.strftime('%H:%M:%S') ).to_s
  }
  puts Colours[:slateblue, Time.now.strftime('%H:%M:%S')]
  pp REVERT
  pp rgb
  pp rgb
  pp rgb
  output_in_a_random_colour 'yo there'
  output_in_a_random_colour 'yo there'
  output_in_a_random_colour 'yo there'
  e; Colours.cliner {
    e 'We will display three random colours next:'
    e '  '+Colours.random_colour?
    e '  '+Colours.random_colour?
    e '  '+Colours.random_colour?
  }
  e 'Is darkgreen a registered colour? '+registered_colour?('darkgreen').to_s
  e Colours.rgb('slateblue')+'yo there'+restore?
  e Colours.rgb(:random)+'yo there'+restore?+' (<-- '+
    Colours.colourize(Colours.last_colour_used?)+')'
    Colours.write_this_in_random_colour('yo man how do you do')
  Colours.cliner
  e 'Next testing direct calls such as: Colours.sienna()'
  e Colours.sienna
  e Colours.sienna('yo there')
  e Colours.lightblue('yo there')
  e Colours.cyan('yo there')
  p darkgreen('ok')
  p lightblue('ok')
  slateblue
  e Colours_colour_slateblue 'hello world!'
  e Colours_colour_darkgreen 'hello world!'
  eslateblue 'yo there'
  Colours.slateblue
  Colours.edarkgreen 'This is Colours.edarkgreen'
  Colours.eslateblue 'This is Colours.eslateblue'
  Bar.new.slateblue
  Bar.slateblue
  e Bar.slateblue('oki doki')
  e; Colours.cliner {
    e 'Next testing 4 occurances of slateblue:'
    e Colours['slateblue','(1) Hello World!']
    eColours_colour_slateblue '(2) hello world!' # This is the same as the above.
    e Colours.slateblue '(3) yo'
    eslateblue '(4) hi world'
  }
  e; Colours.cliner {
    e 'We will next test out Colours.rgb with 3 specific values (R,G,B)'
    e Colours.rgb(122,56,141)+' ok'+rev
    e Colours.rgb(125,61,164)+' ok'+rev
    e Colours.rgb(132,76,198)+' ok'+rev
    e Colours.rgb(262,86,213)+' ok'+rev
  }
  e; Colours.cliner {
    e 'Next we will test the method: write_this_in_random_colour'
    write_this_in_random_colour '  hello world'
    write_this_in_random_colour '  hello world'
    write_this_in_random_colour '  hello world'
  }
  Colours_colours :green, 'Hello world!'
  e Colours_colour_peru 'hey there - this here is Colours_colour_peru()'
  e; Colours.cliner {
    e 'Next testing italic:'
    e Colours.italic('This must be italic.')
    e
    e 'Next testing underline:'
    e Colours.underline('This must be underlined.')
  }
  Colours.display_all_colours # Finally, display all colours here.
end; alias test_Colours_colours Colours_colour_tests # === test_Colours_colours

if __FILE__ == $PROGRAM_NAME
  # Testing code comes next:
  if ARGV.empty?
    Colours_colour_tests # Here we run the various colour-tests.
  else
    Colours.menu(ARGV) # Delegate towards Colours.menu() here.
  end
end # tkon