#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
if __FILE__ == $PROGRAM_NAME
  alias e puts
  require 'colours/constants/constants.rb'
  include Colours
  require 'colours/basic_colours/basic_colours.rb'
  include Colours::BasicColours
  module Colours
    include Colours::BasicColours
  end
  e 'Next testing direct support for colour-constants, such as '\
    'COLOUR_LIGHT_PURPLE or COLOUR_GRAY'
  e COLOUR_LIGHT_PURPLE+'foo bar'+COLOUR_NC
  e COLOUR_GRAY+'foo bar'+COLOUR_NC
  e GREEN+'TEST IN GREEN, THEN THE CLOSING "TAG"'+CLOSING_TAG
  e
  e 'Next, we will directly test for colour-methods such as .gray() or'
  e '.light_gray(), .blue() and so forth:'
  e
  e 'yo '+Colours::BasicColours.gray('there - this is gray') # This one is not visible on a black background.
  e 'yo '+Colours::BasicColours.light_gray('there - this is light gray')
  e 'yo '+Colours::BasicColours.yellow('there - this is yellow')
  e 'yo '+Colours::BasicColours.blue('there - this is blue')
  e 'yo '+Colours::BasicColours.brown('there - this is brown')
  e 'yo '+Colours::BasicColours.red('there - this is red')
  e 'yo '+Colours::BasicColours.white('there - this is white')
  e 'yo '+Colours::BasicColours.purple('there - this is purple')
  e 'yo '+Colours::BasicColours.purple('there - this is green')
  e 'yo '+Colours::BasicColours.light_purple('there - this is light purple')
  e 'yo '+Colours::BasicColours.light_red('there - this is light red')
  e 'yo '+Colours::BasicColours.light_green('there - this is light green')
  e 'yo '+Colours::BasicColours.cyan('there - this is cyan')
  e 'yo '+Colours::BasicColours.light_cyan('there - this is light cyan')
  e 'yo '+Colours::BasicColours.light_blue('there - this is light blue')
  e 'Is this line without colours?'
  e
  e 'Next, we will test whether HASH_SIMPLE_COLOURS contains all keys'
  e 'as methods:'
  keys = HASH_SIMPLE_COLOURS.keys
  e
  keys.each_with_index {|this_method, index| index += 1
    padded_index = ('('+index.to_s+') ').rjust(5)
    e Colours::BasicColours.send(
        this_method,
        padded_index+this_method.to_s+' does exist.'
      )
  }
  e
  e
  e 'Next testing .rev()'
  e
  e Colours.rev
  e
  pp Colours::ARRAY_REGISTERED_ANSI_COLOURS
  e
  e 'Next testing: pp Colours.really_all_colours'
  e
  pp Colours.really_all_colours
end