#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file will modify the toplevel namespace Gtk, as well as include
# BaseModule. The latter is valid for ALL defined classes here in this
# file, so you do not have to manually do a "include ::Gtk::BaseModule"
# anymore. It is recommended to subclass from these classes defined
# in this file, such as via:
#
#   class Foobar < Gtk::BaseModuleBox
#   end
#
# Note that Gtk::BaseModule actually requires this file already, since
# as of November 2023.
# =========================================================================== #
# require 'gtk_paradise/base_module_widgets/base_module_widgets.rb'
# =========================================================================== #
# require 'gtk_paradise/requires/require_the_base_module.rb'
# =========================================================================== #

# =========================================================================== #
# === Gtk::BaseModuleBox
# =========================================================================== #
module Gtk

class BaseModuleBox < ::Gtk::Box # === Gtk::BaseModuleBox

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_widget         = nil,
      optional_padding_to_use = 0 # This argument is currently ignored.
    )
    if optional_widget
      super(optional_widget)
    else # else we will default to a vertical box.
      super(:vertical)
    end
  end

end

# =========================================================================== #
# === Gtk::BaseModuleNotebook
# =========================================================================== #
class BaseModuleNotebook < ::Gtk::Notebook # === Gtk::BaseModuleBox

  include ::Gtk::BaseModule

end

# =========================================================================== #
# === Gtk::BaseModuleWindow
# =========================================================================== #
class BaseModuleWindow < ::Gtk::Window # === Gtk::BaseModuleWindow

  include ::Gtk::BaseModule

end

# =========================================================================== #
# === Gtk::BaseModuleFrame                                        (frame tag)
# =========================================================================== #
class BaseModuleFrame < ::Gtk::Frame # === Gtk::BaseModuleFrame

  include ::Gtk::BaseModule

end

# =========================================================================== #
# === Gtk::BaseModuleButton
# =========================================================================== #
class BaseModuleButton < ::Gtk::Button # === Gtk::BaseModuleButton

  include ::Gtk::BaseModule

end

# =========================================================================== #
# === Gtk::BaseModuleAssistant
# =========================================================================== #
class BaseModuleAssistant < ::Gtk::Assistant # === Gtk::BaseModuleAssistant

  include ::Gtk::BaseModule

end

end