#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/commandline/commandline.rb'
# =========================================================================== #
module Gtk

  require 'gtk_paradise/toplevel_methods/e.rb'

  # ========================================================================= #
  # === Gtk.parse_commandline                               (commandline tag)
  # ========================================================================= #
  def self.parse_commandline(
      i = ARGV
    )
    if i.is_a? Array
      i.each {|entry| parse_commandline(entry) }
    else
      case i # case tag
      # ===================================================================== #
      # === gtkpa --editor
      # ===================================================================== #
      when /^-?-?editor$/
        require 'gtk_paradise/widgets/gtk3/editor/editor.rb'
        Gtk::Editor.run
      # ===================================================================== #
      # === gtkpa --tabble3
      #
      # Note that this variant is the default via "--tabble" since as of
      # January 2021.
      # ===================================================================== #
      when /^-?-?tabble3$/,
           /^-?-?tabble$/i,
           /^-?-?application(-|_)?menu$/,
           /^-?-?rtabble$/,
           /^-?-?amenu$/
        require 'gtk_paradise/widgets/gtk3/tabble/tabble.rb'
        ::Gtk.start_tabble
      # ===================================================================== #
      # === gtkpa --tabble2
      #
      # This variant no longer works as of August 2021. I retain the entry
      # point, though, in the event that we will add support for ruby-gtk2
      # again one day.
      # ===================================================================== #
      when /^-?-?tabble2$/i
        require 'gtk_paradise/widgets/gtk2/application_menu/application_menu.rb'
        ::Gtk::Tabble::Tabble.run
      # ===================================================================== #
      # === gtkpa --panel
      # ===================================================================== #
      when /^-?-?panel/i,
           /^-?-?control/i
        require 'gtk_paradise/widgets/gtk3/control_panel/control_panel.rb'
        ::Gtk::ControlPanel.run
      # ===================================================================== #
      # === gtkpa --show-icon-theme
      # ===================================================================== #
      when /^-?-?show(-|_)?icon(-|_)?theme/i
        require 'gtk_paradise/widgets/gtk3/show_icon_theme/show_icon_theme.rb'
        ::Gtk::ShowIconTheme.run
      # ===================================================================== #
      # === gtkpa --tabby
      # ===================================================================== #
      when /^-?-?tabby$/
        require 'gtk_paradise/widgets/gtk2/tabby/tabby.rb'
        ::Gtk::Tabble::Tabble.run
      # ===================================================================== #
      # === gtkpa --mastermind3
      # ===================================================================== #
      when /^-?-?mastermind3?$/i
        require 'gtk_paradise/games/gtk3/mastermind/mastermind.rb'
        ::Gtk::Mastermind::Mastermind.run
      # ===================================================================== #
      # === gtkpa --mastermind2
      # ===================================================================== #
      when /^-?-?mastermind2$/i
        require 'gtk_paradise/games/mastermind/mastermind.rb'
        Gtk::Mastermind.run
      # ===================================================================== #
      # === gtkpa --hello-world2
      # ===================================================================== #
      when /^-?-?hello(-|_)?world2$/
        require 'gtk_paradise/hello_world/hello_world_gtk2.rb'
        HelloWorldGtk2.new
      # ===================================================================== #
      # === gtkpa --hello
      # ===================================================================== #
      when /^-?-?hello$/i,
           /^-?-?hello(-|_)?world3?$/
        require 'gtk_paradise/hello_world/hello_world_gtk3.rb'
        HelloWorldGtk3.new
     # ===================================================================== #
      # === gtkpa --emoji
      # ===================================================================== #
      when /^-?-?emojis?$/i
        require 'gtk_paradise/widgets/gtk3/emoji_widget/emoji_widget.rb'
        ::Gtk::EmojiWidget.run
      # ===================================================================== #
      # === gtkpa --help
      # ===================================================================== #
      when /^-?-?help$/i
        e 'These options are available right now:'
        e
        e '  gtk_paradise --tabble     # starts the tabble-interface'
        e '  gtk_paradise --tabble2    # as above ^^^, but ruby-gtk2 '\
          'is used'
        e '  gtk_paradise --tabble3    # as above ^^^, but ruby-gtk3 '\
          'is used (this is the default nowadays)'
        e '  gtk_paradise --mastermind # starts mastermind'
        e '  gtk_paradise --emoji      # starts the emoji-widget '\
          'showing lots of emojis'
        e
      # ===================================================================== #
      # === gtkpa --conky
      # ===================================================================== #
      when /^-?-?conky/i
        require 'gtk_paradise/widgets/gtk3/conky/conky.rb'
        ::Gtk::Conky.run
      end
    end
  end

end

if __FILE__ == $PROGRAM_NAME
  Gtk.parse_commandline(ARGV)  
end