#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/accel_group.rb'
# =========================================================================== #
module Gtk

class AccelGroup # === Gtk::AccelGroup

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # =========================================================================== #
  # === alt_key
  #
  # This method can be used to specify an alt key, and then an
  # additional modifier key - in the example below being "1".
  #
  # So the default code means "press ALT key and the 1 key".
  # =========================================================================== #
  def alt_key(
      use_this_additional_modifier_key = Gdk::Keyval::GDK_1,
      &block
    )
    use_this_mask_key = :mod1_mask # For ruby-gtk3 and ruby-gtk4.
    connect(
      use_this_additional_modifier_key,
      use_this_mask_key,
      :visible,
      &block
    )
  end

end; end