#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Cairo::Context
# =========================================================================== #
# require 'gtk_paradise/core_classes/cairo/context.rb'
# =========================================================================== #
module Cairo

class Context # === Cairo::Context

  # ========================================================================= #
  # Enable ad-hoc support for the colours gem, if IS_ROEBE is defined.
  # ========================================================================= #
  if ENV.has_key? 'IS_ROEBE'
    begin
      require 'colours' unless Object.const_defined?(:Colours)
    rescue LoadError; end
  end

  # ========================================================================= #
  # === background_colour=
  #
  # This method can be used to set to a background colour for a
  # cairo-context.
  # ========================================================================= #
  def background_colour=(i = :steelblue)
    # ======================================================================= #
    # We must simply convert the given HTML colour into its corresponding
    # RGB value. This is done, for example, by the "colours" gem.
    # ======================================================================= #
    if Object.const_defined? :Colours
      i = ::Colours.html_colour_to_rgb_value(i) # => "220;20;60"
      if i.is_a? String
        splitted = i.split(';').map {|entry|
          # ================================================================= #
          # Need to convert e. g. 220 into a value range of 0-1.
          # The official documentation states that "The color components
          # are floating point numbers in the range 0 to 1.
          # Note that Black is [0,0,0] and White is [255, 255, 255].
          # Thus, we must narrow 255 towards 1, and 0 towards 0.
          # ================================================================= #
          (entry.to_f / 255.0)
        }
        set_source_rgb(*splitted)
      end
    else
      puts 'No colour-related gem is available. Consider '\
           'installing one like so: gem install colours'
    end
  end; alias background_color= background_colour= # === background_color?

end; end