#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ComboBox
#
# Modifications to Gtk::ComboBox, as part of the gtk_paradise project,
# will reside in this .rb file here.
# =========================================================================== #
# require 'gtk_paradise/core_classes/combo_box.rb'
# =========================================================================== #
module Gtk

class ComboBox # === Gtk::ComboBox

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === populate_with
  #
  # This method can be used to populate (or re-populate) a combo-box with
  # text entries.
  # ========================================================================= #
  def populate_with(*i)
    i.flatten.compact.each {|entry|
      append(entry)
    }
  end; alias populate                   populate_with # === populate
       alias populate_with_this_dataset populate_with # === populate_with_this_dataset
       alias populate_with_this_array   populate_with # === populate_with_this_array
       alias fill_with                  populate_with # === fill_with

  # require 'gtk_paradise/toplevel_methods/enable_and_disable_warnings.rb'
  #::Gtk.disable_warnings
  # alias :old_init :initialize
  # remove_method :initialize # Remove initialize, silently. But this is not a good idea ...
  #::Gtk.re_enable_warnings

  # ========================================================================= #
  # === initialize
  #
  # Unfortunately I do not quite know how to safely re-define initialize.
  # ========================================================================= #
  # def initialize(hash = {})
  #   super(hash)
  #   if block_given?
  #     yielded = yield
  #     case yielded
  #     # =================================================================== #
  #     # Add tearoffs to this combo box entry:
  #     # =================================================================== #
  #     when :use_tearoffs
  #       self.add_tearoffs = true
  #     end
  #   end
  # end

  # ========================================================================= #
  # === fill
  #
  # This method can be used to pass an Array for filling the combo-box
  # at hand.
  # ========================================================================= #
  def fill(i)
    if i.is_a? Array
      i.each {|entry| fill(entry) }
    else
      append_text(i)
    end
  end

  # ========================================================================= #
  # === first_entry_is_default
  # ========================================================================= #
  def first_entry_is_default
    self.active = 0
  end; alias focus_on_the_first_element first_entry_is_default # === focus_on_the_first_element
       alias first_entry_is_active      first_entry_is_default # === first_entry_is_active
       alias the_first_entry_is_active  first_entry_is_default # === the_first_entry_is_active
       alias first_entry_is_default     first_entry_is_default # === first_one_is_default
       alias first_is_default           first_entry_is_default # === first_is_default

  # ========================================================================= #
  # === selected?
  # ========================================================================= #
  def selected?
    active_text
  end; alias selection? selected? # === selection?

end

# =========================================================================== #
# === Gtk.combo_box
#
# The input to this method should be the Array of items to be added.
#
# Note that Gtk::ComboBox is NOT the same as Gtk::ComboBoxEntry.
# =========================================================================== #
def self.combo_box(
    i                            = nil,
    accept_only_strings_as_input = :default
  )
  case accept_only_strings_as_input
  # ========================================================================= #
  # === :only_strings
  # ========================================================================= #
  when :only_strings,
       :strings_only,
       :default
    accept_only_strings_as_input = true
  end
  combo_box = ::Gtk::ComboBox.new
  # ========================================================================= #
  # Next add all array-entries to that combo box.
  # ========================================================================= #
  if i and i.is_a? Array # Handle Arrays here.
    i.each {|entry|
      combo_box.append_text(entry.to_s) # Batch-add the components here.
    }
  end
  return combo_box
end

end