#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::EntryCompletion
# =========================================================================== #
# require 'gtk_paradise/core_classes/entry_completion.rb'
# =========================================================================== #
module Gtk

class EntryCompletion # === Gtk::EntryCompletion

  # require 'gtk_paradise/core_classes/widget.rb'

  # ========================================================================= #
  # === populate_with_this_array
  #
  # This method assumes that the input is an Array of Strings.
  # ========================================================================= #
  def populate_with_this_array(
      array
    )
    array.flatten! # Always keep it flat.
    model = ::Gtk::ListStore.new(String) # This is our model.
    array.each { |word|
      iter = model.append
      iter[0] = word
    }
    self.model = model
    first_text_column_is_active
  end; alias set_completion populate_with_this_array # === set_completion

  # ========================================================================= #
  # === first_text_column
  # ========================================================================= #
  def first_text_column
    self.text_column = 0
  end; alias first_text_column_is_active first_text_column # === first_text_column

  # ========================================================================= #
  # === enable_all_events
  #
  # This can be used for quick debugging, when you have a widget that is
  # not responding to some events, to simply turn them all on.
  #
  # This currently only works for ruby-gtk3. Not sure if we should enable
  # it for ruby-gtk2 as well.
  #
  # Note that this may lead to a few problems, so it is almost always
  # better to only enable the events that you really really need in
  # your application.
  # ========================================================================= #
  def enable_all_events(
      i = Gdk::EventMask::ALL_EVENTS_MASK
    )
    set_events(i) 
  end; alias all_events enable_all_events # === all_events

  # ========================================================================= #
  # === on_key_pressed
  #
  # When the user hits the enter key, we will do an action supplied
  # in via the yield method.
  # ========================================================================= #
  def on_key_pressed(
      this_key = :enter
    )
    signal_connect(:key_press_event) {|widget, event|
      if ::Gtk.enter_key?(event) # Handle the enter-key here.
        yield if block_given?
      end
    }
  end; alias click_event_when_enter_key_was_pressed on_key_pressed # === click_event_when_enter_key_was_pressed
       alias on_enter_key                           on_key_pressed # === on_enter_key
       alias on_enter_key_pressed                   on_key_pressed # === on_enter_key_pressed
       alias on_enter                               on_key_pressed # === on_enter
       alias on_enter_key_clicked                   on_key_pressed # === on_enter_key_clicked

end; end