#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::EventBox
# =========================================================================== #
# require 'gtk_paradise/core_classes/event_box.rb'
# =========================================================================== #
module Gtk

class EventBox # === Gtk::EventBox

  # ========================================================================= #
  # === on_click_event
  #
  # This event is triggered when the user does a mouse-button press
  # action on the event-box at hand.
  # ========================================================================= #
  def on_click_event(&block)
    signal_connect(:event) { |widget, event|
      case event.event_type.name
      when 'GDK_BUTTON_PRESS' # or 'BUTTON_PRESS_MASK'
        yield
      end
    }
  end; alias on_clicked  on_click_event # === on_click_event
       alias on_click_do on_click_event # === on_click_do
       alias on_click    on_click_event # === on_click

  # ========================================================================= #
  # === x_position?
  # ========================================================================= #
  def x_position?
    x
  end; alias x_coordinate? x_position? # === x_coordinate?

  # ========================================================================= #
  # === y_position?
  # ========================================================================= #
  def y_position?
    y
  end; alias y_coordinate? y_position? # === y_coordinate?

end

# =========================================================================== #
# === Gtk.event_box
#
# If an argument is supplied to this method then it is assumed that
# the user wants to attach a particular widget to a Gtk::EventBox,
# as-is.
# =========================================================================== #
def self.event_box(
    optional_argument = nil
  )
  if optional_argument
    ::Gtk::EventBox.new.add(optional_argument)
  else
    ::Gtk::EventBox.new
  end
end; self.instance_eval { alias eventbox event_box } # === Gtk.eventbox

end