#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Menu
# =========================================================================== #
# require 'gtk_paradise/core_classes/menu.rb' 
# =========================================================================== #
module Gtk

class Menu # === Gtk::Menu

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === popup_based_on_this_event
  # ========================================================================= #
  def popup_based_on_this_event(event)
    popup(
      nil,
      nil,
      event.button,
      event.time
    )
  end

  # ========================================================================= #
  # === make_bold
  #
  # This method will try to make all members of the menu bold, when
  # it is text.
  # ========================================================================= #
  def make_bold
    children?.each {|this_gtk_menu_item| # This is: Gtk::MenuItem
      this_gtk_menu_item.make_bold 
    }
  end

  # ========================================================================= #
  # === append_separator
  # ========================================================================= #
  def append_separator
    ::Gtk::MenuItem.new(label: nil)
  end

  # ========================================================================= #
  # === append_these
  # ========================================================================= #
  def append_these(*i)
    i.each { |entry| self.append(entry) }
  end

end

  # ========================================================================= #
  # === Gtk.return_gtk_menu
  #
  # This is the constructor method for when you wish to add a menu.
  # ========================================================================= #
  def self.return_gtk_menu(
      use_this_accelgroup = Gtk::AccelGroup.new
    )
    use_this_logo = '/home/x/data/images/GUI/GTK/STOCK_ITEMS/'\
                    'stock_stop_24.png'
    cal_stock  = Proc.new {|d, _item| p "StockItem, #{d}"}
    cal_quit   = Proc.new { Gtk.main_quit} # Quitting.
    cal_check  = Proc.new {|d, _item| p "CheckItem, #{d}"}
    cal_toggle = Proc.new {|d, _item| p "ToggleItem, #{d}"}
    cal_radio  = Proc.new {|d, _item| p "RadioItem, #{d}"}
    cal_misc   = Proc.new {|d, _item| p "Misc #{d}"}

    item_factory = Gtk::ItemFactory.new(
      Gtk::ItemFactory::TYPE_MENU_BAR,
      '<main>', use_this_accelgroup
    )

    item_factory.create_items([

    ['/_Stock'],
    ['/_Stock/_New',  '<StockItem>', '<control>N', Gtk::Stock::NEW,  cal_stock, 1],
    ['/_Stock/_Open', '<StockItem>', '<control>O', Gtk::Stock::OPEN, cal_stock, 2],
    ['/_Stock/_Quit', '<StockItem>', '<control>Q', Gtk::Stock::QUIT, cal_quit],

    ['/_Check'],
    ['/_Check/Check_1', '<CheckItem>', '', '', cal_check, 1],
    ['/_Check/Check_2', '<CheckItem>', '', '', cal_check, 2],

    ['/_Toggle'],
    ['/_Toggle/Toggle_1', '<ToggleItem>', '', '', cal_toggle, 1],
    ['/_Toggle/Toggle_2', '<ToggleItem>', '', '', cal_toggle, 2],
    ['/_Toggle/Toggle_3', '<ToggleItem>', '', '', cal_toggle, 3],

    ['/_Radio', '<Branch>'],
    ['/_Radio/Radio_1', '<RadioItem>',   nil, nil, cal_radio, 1],
    ['/_Radio/Radio_2', '/Radio/Radio1', nil, nil, cal_radio, 2],
    ['/_Radio/Radio_3', '/Radio/Radio1', nil, nil, cal_radio, 3],

    ['/_Misc',           '<LastBranch>'],
    ['/_Misc/Tearoff',   '<Tearoff>'],
    ['/_Misc/Title',     '<Title>'],
    ['/_Misc/Image',     '<ImageItem>', '',
      GdkPixbuf::Pixbuf.new(file: use_this_logo),
      cal_misc, 1
    ],
    ['/_Misc/Separator', '<Separator>'],
    ['/_Misc/Item',      '<Item>', nil, nil, cal_misc, 2]

    ])
    # item_factory.get_widget('/Stock/Open').sensitive = false
    # item_factory.delete_item('/Toggle/Toggle2') # Deleting an Item now.
    return item_factory.get_widget('<main>')
  end; self.instance_eval { alias add_gtk_menu return_gtk_menu } # === Gtk.add_gtk_menu

end