#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/popover.rb'
# =========================================================================== #
module Gtk

class Popover # === Gtk::Popover

  # ========================================================================= #
  # === disable_arrow
  #
  # This method will disable showing an arrow pointing at the widget
  # it is relative to.
  #
  # The C-method is gtk_popover_set_has_arrow().
  #
  # This only works on gtk4, unfortunately. I was unable to get this to
  # work for gtk3, but I did file a report to upstream GTK.
  # ========================================================================= #
  def disable_arrow
    set_has_arrow(false)
  end; alias no_arrow disable_arrow # === no_arrow

end; end