#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/radio_menu_item.rb'
# =========================================================================== #
module Gtk

class RadioMenuItem # === Gtk::RadioMenuItem

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === checked?
  # ========================================================================= #
  def checked?
    active?
  end

  # ========================================================================= #
  # === is_active
  # ========================================================================= #
  def is_active
    set_active(true)
  end

  # ========================================================================= #
  # === is_inactive
  # ========================================================================= #
  def is_inactive
    set_active(false)
  end; alias is_not_checked is_inactive # === is_not_checked

end

  # ========================================================================= #
  # === Gtk.gtk_radio_menu_item
  #
  # A radio menu item is a check menu item that belongs to a specific group.
  #
  # Radio menu items are mutually exclusive, that is, you can only select
  # one entry there.
  #
  # Official documentation for Gtk::RadioMenuItem can be seen here:
  #
  #   https://ruby-gnome2.osdn.jp/hiki.cgi?Gtk%3A%3ARadioMenuItem
  #
  # ========================================================================= #
  def self.gtk_radio_menu_item(
      group_to_use       = nil,
      label_for_the_text = '',
      use_underline      = false
    )
    ::Gtk::RadioMenuItem.new(
      group_to_use,
      label_for_the_text,
      use_underline
    )
  end; self.instance_eval { alias radio_menu_item gtk_radio_menu_item } # === Gtk.radio_menu_item

end