#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScrolledWindow
#
# This file contains modification to Gtk::ScrolledWindow.
# =========================================================================== #
# require 'gtk_paradise/core_classes/scrolled_window.rb'
# =========================================================================== #
module Gtk

class ScrolledWindow # === Gtk::ScrolledWindow

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === use_etched_in_shadow
  # ========================================================================= #
  def use_etched_in_shadow(
      i = :etched_in # Default value for ruby-gtk3.
    )
    # if ::Gtk.use_gtk2?
    #   i = ::Gtk::SHADOW_ETCHED_IN
    # end
    set_shadow_type(i)
  end; alias etched_in_shadow use_etched_in_shadow # === etched_in_shadow 

  # ========================================================================= #
  # === set_shadow_type_in
  #
  # This variant will work both on ruby-gtk2 and on ruby-gtk3.
  # ========================================================================= #
  def set_shadow_type_in(
      i = :in
    )
    # if ::Gtk.use_gtk2?
    #   i = ::Gtk::SHADOW_IN
    # else # assume gtk3
    # end
    set_shadow_type(i)
  end; alias shadow_in set_shadow_type_in # === shadow_in

  # ========================================================================= #
  # === window_bottom_left
  # ========================================================================= #
  def window_bottom_left(
      i = :bottom_left 
    )
    # if ::Gtk.use_gtk2?
    #  i = ::Gtk::CORNER_BOTTOM_LEFT
    # end
    set_window_placement(i)
  end

  # ========================================================================= #
  # === read_only
  #
  # This will only work when the child responds to the .read_only()
  # method. This is the case for text-view widgets.
  # ========================================================================= #
  def read_only
    this_child_widget = children.first.children.first
    this_child_widget.read_only if this_child_widget.respond_to? :read_only
  end

  # ========================================================================= #
  # === set_text
  # ========================================================================= #
  def set_text(i = '')
    this_child_widget = children.first.children.first
    this_child_widget.set_text(i) if this_child_widget.respond_to? :set_text
  end

  # ========================================================================= #
  # === text?
  # ========================================================================= #
  def text?
    this_child_widget = children.first.children.first
    this_child_widget.text? if this_child_widget.respond_to? :text?
  end

  # ========================================================================= #
  # === policy=
  #
  # This is a shorthand variant that works both on ruby-gtk2 and on
  # ruby-gtk3.
  # ========================================================================= #
  def policy=(
      a = :never,
      b = :automatic
    )
    if ::Gtk.use_gtk2? # This will eventually be removed.
      case a
      # ===================================================================== #
      # === :never
      # ===================================================================== #
      when :never
        a = ::Gtk::POLICY_NEVER
      end
      case b
      # ===================================================================== #
      # === :automatic
      # ===================================================================== #
      when :automatic,
           :automatic_policy
         b = ::Gtk::POLICY_AUTOMATIC
      end
    end
    if a.is_a?(Array) and (a.size > 1)
      b = a[1]
      a = a[0]
    end
    set_policy(a, b)
  end

  # ========================================================================= #
  # === do_show_the_scrollbars
  # ========================================================================= #
  def do_show_the_scrollbars
    # if ::Gtk.use_gtk2?
    #   set_policy(
    #     ::Gtk::POLICY_ALWAYS,
    #     ::Gtk::POLICY_ALWAYS
    #   )
    # else
    set_policy(
      :always,
      :always
    )
  end; alias show_scrollbars            do_show_the_scrollbars # === show_scrollbars
       alias always_show_the_scrollbars do_show_the_scrollbars # === always_show_the_scrollbars

  # ========================================================================= #
  # === automatic_policy
  #
  # This method will enable "automatic-policy" for ruby-gtk2 and ruby-gtk3.
  # ========================================================================= #
  def automatic_policy
    # if ::Gtk.use_gtk2?
    #   set_policy(
    #     ::Gtk::POLICY_AUTOMATIC,
    #     ::Gtk::POLICY_AUTOMATIC
    #   )
    # else
    set_policy(
      :automatic,
      :automatic
    )
  end; alias automatic_scrollbars automatic_policy # === automatic_scrollbars

  # ========================================================================= #
  # === policy_always
  # ========================================================================= #
  def policy_always(
      always1 = :always,
      always2 = :always
    )
    # if ::Gtk.use_gtk2?
    #   always1 = ::Gtk::POLICY_ALWAYS
    #   always2 = ::Gtk::POLICY_ALWAYS
    # end
    set_policy(always1, always2)
  end

end

# =========================================================================== #
# === Gtk.scrolled_window
#
# In December 2023 the first argument to this method was changed. Before
# that it would default to ::Gtk.textview, but this is not ideal, as
# sometimes we may want to just obtain an as-of-yet empty scrolled
# window. 
# =========================================================================== #
def self.scrolled_window(
    use_this_widget = nil,
    &block
  )
  case use_this_widget
  # ========================================================================= #
  # === :default
  # ========================================================================= #
  when :default
    use_this_widget = ::Gtk.textview
  end
  # ========================================================================= #
  # Create a new scrolld window next - this has to happen whenever this
  # method is invoked.
  # ========================================================================= #
  scrolled_window = ::Gtk::ScrolledWindow.new
  # ========================================================================= #
  # === Handle blocks given to this method next
  # ========================================================================= #
  if block_given?
    yielded = yield
    case yielded
    # ======================================================================= #
    # === :always
    # ======================================================================= #
    when :always
      scrolled_window.policy_always
    end
  end
  if use_this_widget
    scrolled_window.add_with_viewport(use_this_widget)
  else
    scrolled_window
  end
end; self.instance_eval { alias return_scrolled_window scrolled_window } # === Gtk.return_scrolled_window

end