#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SourceBuffer
#
# One extension to Gtk::SourceBuffer. Note that this seems to be not
# massively in use anymore - or at the least it seems that way,
#
# You might want to use Gtk::TextView.new instead.
# =========================================================================== #
# require 'gtk_paradise/core_classes/source_buffer.rb'
# =========================================================================== #
module Gtk

class SourceBuffer # === Gtk::SourceBuffer

  # ========================================================================= #
  # === get_cursor_at_iter
  #
  # Doesnt quite work hmm.
  # ========================================================================= #
  def get_cursor_at_iter
    return self.get_iter_at_mark(
      get_mark('insert')
    )
  end

  # ========================================================================= #
  # === do_use_ruby
  #
  # This method will "enable" support for ruby, in a SourceBuffer
  # instance.
  # ========================================================================= #
  def do_use_ruby
    buffer.language = ::Gtk::SourceLanguageManager.new.get_language('ruby')
    buffer.highlight_syntax = true
    buffer.highlight_matching_brackets = true
  end; alias use_ruby do_use_ruby # === use_ruby

end

# =========================================================================== #
# === Gtk.return_sourcecode
# =========================================================================== #
def self.return_sourcecode
  Gtk::SourceBuffer.new
end

end