#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SourceView
#
# Do note that since this file depends on "gtksourceview2", it is not
# required by default. You have to explicitely require it on your own
# for now.
# =========================================================================== #
# require 'gtk_paradise/core_classes/source_view.rb'
# =========================================================================== #
module Gtk

class SourceView # === Gtk::SourceView

  # ========================================================================= #
  # === use_sane_default_values
  #
  # This method can be used to use sane default values - values which
  # I think make a lot of sfense for a SourceView instance.
  # ========================================================================= #
  def use_sane_default_values
    self.show_line_numbers = true
    self.insert_spaces_instead_of_tabs = true
    self.indent_width = 2
    self.show_right_margin = true
    self.right_margin_position = 80
  end; alias do_use_sane_defaults use_sane_default_values # === do_use_sane_defaults

end

# =========================================================================== #
# === Gtk.return_sourceview
# =========================================================================== #
def self.return_sourceview
  ::Gtk::SourceView.new
end

# =========================================================================== #
# === create_gtk_source_view
# =========================================================================== #
def create_gtk_source_view(buffer_to_use)
  Gtk.create_gtk_source_view(buffer_to_use)
end
  
end