#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::StatusIcon
# =========================================================================== #
# require 'gtk_paradise/core_classes/status_icon.rb'
# status_icon.use_this_image = '/Depot/j/foobar.png'
# =========================================================================== #
module Gtk

class StatusIcon

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === favicon
  #
  # This variant is more flexible, in my opinion. It can be used to
  # designate a favicon.
  # ========================================================================= #
  def favicon(i)
    if File.exist? i
      self.from_file = i
      set_icon_name(
        i.delete_suffix(File.extname(i))
      ) 
    else
      e "No file found at `#{i}`."
    end
  end; alias favicon= favicon # === favicon=

  # ========================================================================= #
  # === fancy_tooltips=
  # ========================================================================= #
  def fancy_tooltips=(i)
    self.tooltip_markup = i # === pretty_tooltip
  end; alias hint= fancy_tooltips= # === hint=
       alias hint  fancy_tooltips= # === hint

  # ========================================================================= #
  # === dialog_info
  # ========================================================================= #
  def dialog_info
    set_stock(::Gtk::Stock::DIALOG_INFO)
  end

  # ========================================================================= #
  # === use_this_image=
  #
  # Pass the path (filepath) to the image into this method.
  #
  # Example:
  #
  #   status_icon.use_this_image = '/Depot/j/foobar.png'
  #
  # ========================================================================= #
  def use_this_image=(i)
    use_this_hash = { file: i }
    if i
      self.pixbuf = { file: GdkPixbuf::Pixbuf.new(use_this_hash) }
    end
  end; alias image= use_this_image= # === image=

end

# =========================================================================== #
# === Gtk.create_status_icon
#
# You can use this method to create a status icon.
#
# The various arguments are optional.
#
# icon_name could be Gtk::Stock::DIALOG_INFO, for instance.
#
# Specific usage example would be this:
#
#   @status_icon = Gtk.create_status_icon(title, icon_name, tooltip, pixbuf)
#
# =========================================================================== #
def self.create_status_icon(
    title           = nil,
    icon_name       = nil,
    tooltip         = nil, # Whether to display a tooltip or whether we should not.
    pixbuf_location = nil  # This could also be called pixbuf_location
  )
  status_icon = ::Gtk::StatusIcon.new
  if title
    status_icon.set_title title
  end
  if icon_name
    status_icon.set_icon_name(icon_name)
  end
  if tooltip
    status_icon.set_tooltip(tooltip)
  end
  if pixbuf_location
    status_icon.pixbuf = GdkPixbuf::Pixbuf.new(file: pixbuf_location)
  end
  return status_icon # Last but not least, return the status icon here.
end; self.instance_eval { alias status_icon create_status_icon } # === Gtk.status_icon

end