#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Statusbar
# =========================================================================== #
# require 'gtk_paradise/core_classes/statusbar.rb'
# =========================================================================== #
module Gtk

class Statusbar # === Gtk::Statusbar

  # ========================================================================= #
  # === add_this_message
  # ========================================================================= #
  def add_this_message(
      display_this_message  = '',
      context_id            = :default,
      status_bar_context_id = @status_bar_context_id
    )
    if display_this_message.is_a? Array
      display_this_message = display_this_message.first
    end
    case context_id
    # ======================================================================= #
    # === :default
    # ======================================================================= #
    when :default
      context_id = status_bar_context_id
    end
    context_id = 0 if context_id.nil?
    display_this_message = display_this_message.to_s
    push(context_id, display_this_message)
  end; alias add_to_statusbar add_this_message # === add_to_statusbar
       alias display          add_this_message # === display
       alias push_message     add_this_message # === push_message

  # ========================================================================= #
  # === set_text
  # ========================================================================= #
  def set_text(i)
    add_this_message(:default, i)
  end; alias show_this_message set_text # === show_this_message

end; end