#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::StyleContext
# =========================================================================== #
# require 'gtk_paradise/core_classes/style_context.rb'
# =========================================================================== #
module Gtk

class StyleContext # === Gtk::StyleContext

end

# =========================================================================== #
# === Gtk.style_context_provider
#
# The argument provider should be a CSS provider.
#
# For ffi-gtk3 you can usethe following API:
#
#   Gtk.style_context_provider(:default, false)
#
# =========================================================================== #
def self.style_context_provider(
    provider              = :default,
    check_for_the_version = true
  )
  case provider
  # ========================================================================= #
  # === :default
  # ========================================================================= #
  when :default
    provider = ::Gtk::CssProvider.new
  end
  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'
  # ========================================================================= #
  # Handle ruby-gtk3 first:
  # ========================================================================= #
  if check_for_the_version
    if use_gtk3?
      ::Gtk::StyleContext.add_provider_for_screen(
        Gdk::Screen.default,
        provider,
        ::Gtk::StyleProvider::PRIORITY_APPLICATION
      )
    # ========================================================================= #
    # Handle ruby-gtk4 next:
    # ========================================================================= #
    elsif use_gtk4?
      ::Gtk::StyleContext.add_provider_for_display(
        Gdk::Display.default,
        provider,
        ::Gtk::StyleProvider::PRIORITY_APPLICATION
      )
    end
  else # else assume gtk3.
    if Gdk::Screen.respond_to? :default
      screen = Gdk::Screen.default
    else # this here is for ffi-gtk
      screen = Gdk::Screen.get_default
    end
    ::Gtk::StyleContext.add_provider_for_screen(
      screen,
      provider,
      ::Gtk::StyleProvider::PRIORITY_APPLICATION
    )
  end
end
    
end