#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TreeIter
# =========================================================================== #
# require 'gtk_paradise/core_classes/tree_iter.rb'
# =========================================================================== #
module Gtk

class TreeIter # === Gtk::TreeIter

  # ========================================================================= #
  # === text?
  #
  # This is similar to first, but applies .to_s on it.
  # ========================================================================= #
  def text?
    first.to_s
  end

  # ========================================================================= #
  # === second
  # ========================================================================= #
  def second
    self[1]
  end

  # ========================================================================= #
  # === first
  #
  # This method obtains the first element in a TreeIter.
  # ========================================================================= #
  def first
    self[0]
  end

  # ========================================================================= #
  # === second_selection?
  # ========================================================================= #
  def second_selection?
    second.text?
  end; alias second_selection second_selection? # === second_selection

  # ========================================================================= #
  # === backward_case_insensitive_search
  # ========================================================================= #
  def backward_case_insensitive_search(
      str, flags, limit = nil
    )
    unless limit
      limit = self.buffer.start_iter
    end

    text = self.buffer.get_slice(limit, self)
    match = /(#{Regexp.escape(str.utf8_reverse)})/i.match(text.utf8_reverse)

    if match
      backward_search(match[0].utf8_reverse, flags, limit)
    else
      nil
    end
  end

  # ========================================================================= #
  # === forward_case_insensitive_search
  # ========================================================================= #
  def forward_case_insensitive_search(
      str,
      flags,
      limit = nil
    )
    unless limit
      limit = self.buffer.end_iter
    end

    text = get_slice(limit)
    match = /(#{Regexp.escape(str)})/i.match(text)

    if match
      forward_search(match[0], flags, limit)
    else
      nil
    end
  end

end; end