#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Drawing::Star
# =========================================================================== #
# require 'gtk_paradise/drawing/star.rb'
# =========================================================================== #
module Gtk

module Drawing

require 'gtk_paradise/drawing/tool.rb'

class Star < Tool # === Gtk::Drawing::Star

  require 'matrix'
  include Math

  module Add
    refine Vector do
      def to_w(o)
        v = self
        [o[0] + v[0], o[1] - v[1]]
      end
    end
  end

  using Add
    
  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      fill,
      x1,
      y1,
      x2,
      y2,
      color
    )
    reset
    @fill = fill
    @o[0] = x1
    @o[1] = y1
    @a[0] = Vector[x2 - x1, y1 - y2]
    θ = PI / 5
    rt1 = Matrix[
      [
        cos(θ),
       -sin(θ)
      ],
      [
        sin(θ),
        cos(θ)
      ]
    ]
    rt2 = rt1 * rt1
    1.upto(4) {|i| @a[i] = rt2 * @a[i - 1]}
    t = cos(2 * θ) / cos(θ)
    @b[0] = rt1 * @a[0] * t
    1.upto(4) {|i| @b[i] = rt2 * @b[i - 1]}
    super()
    @color = color
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    @o = []
    @a = []
    @b = []
  end

  # ========================================================================= #
  # === draw_triangle
  # ========================================================================= #
  def draw_triangle(n)
    array = [
      @a[n].to_w(@o),
      @b[n].to_w(@o),
      @b[(n - 1) % 5].to_w(@o)
    ]
    polygon(@fill, array)
  end; private :draw_triangle

  # ========================================================================= #
  # === draw
  # ========================================================================= #
  def draw
    if @fill
      5.times {|i| draw_triangle(i)}
      ar = []
      5.times {|i| ar << @b[i].to_w(@o)}
      polygon(@fill, ar)
    else
      array = []
      5.times {|i|
        array << @a[i].to_w(@o)
        array << @b[i].to_w(@o)
      }
      polygon(@fill, array)
    end
  end

end; end; end