#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

class SourceWindow < Gtk::BaseModuleWindow

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super('Source Window')
    @label = gtk_label('Drag start here!')
    add(@label)
    set_default_size(125, 125)
    drag_source_set(Gdk::ModifierType::BUTTON1_MASK |
                    Gdk::ModifierType::BUTTON2_MASK,
                    [['test', Gtk::TargetFlags::SAME_APP, 12345]],
                    Gdk::DragAction::COPY |
                    Gdk::DragAction::MOVE)
    # on_drag_data_get {
    signal_connect(:drag_data_get) { |widget, context, selection_data, info, time|
      e 'event: drag_data_get'
      selection_data.set(Gdk::Selection::TYPE_STRING, "hoge.txt")
    }
    run
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    move(0, 0)
  end

end

class DestinationWindow < Gtk::BaseModuleWindow

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super('Dest Window')
    reset
    @label = label('Drop here!')
    add(@label)
    set_default_size(125, 125)
    drag_dest_set(Gtk::DestDefaults::MOTION |
                  Gtk::DestDefaults::HIGHLIGHT,
                  [['test', :same_app, 12345]],
                  Gdk::DragAction::COPY |
                  Gdk::DragAction::MOVE)

    signal_connect(:drag_data_received) { |widget, context, x, y, selection_data, info, time|
      e steelblue('A drop event occurred.')
      @counter_n_drop_events_occurred += 1
      @label.set_text(
        'Drop more onto me!!! I am sooooo hungry! Now I have been '\
        'fed '+@counter_n_drop_events_occurred.to_s+' times.'
      )
      # pp context.targets
      context.targets.each { |target|
        pp target.name
        if target.name == 'test' ||
           selection_data.type == Gdk::Selection::TYPE_STRING
          puts selection_data.data
        end
      }
    }
    signal_connect(:drag_drop) { |widget, context, x, y, time|
      e 'event: drag_drop'
      widget.drag_get_data(context, context.targets[0], time)
    }
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @counter_n_drop_events_occurred = 0
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    move(125, 125)
  end

end

if __FILE__ == $PROGRAM_NAME
  win1 = SourceWindow.new
  win1.move(0, 0)
  win1.show_all.signal_connect(:destroy) { Gtk.main_quit }

  win2 = DestinationWindow.new
  win2.move(135, 0)
  win2.show_all.signal_connect(:destroy) { Gtk.main_quit }

  Gtk.main  
end