#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HtmlLikeSupport
# =========================================================================== #
# require 'gtk_paradise/example/advanced/html_like_support.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class HtmlLikeSupport < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'HTML-like support'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1280

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 580

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, :dejavu_condensed_22)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # Add more ad-hoc CSS rules next:
    # ======================================================================= #
    more_css '
.blightgreen5 { border: 8px solid lightgreen; }
.bblack5      { border: 8px solid black; }
.bgreen5      { border: 8px solid green; }

.yoda {
  color: yellow;
}

.BG_Black {
  background-color: black;
}

'
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(
      h2 'Interessantes Wissen rund um CSS und GTK',
         'martb2px'
    )
    minimal(
      gtk_left_aligned_label('CSS-buttons:')
    )

    button1 = gtk_button('Button #1')
    button1.width_height(30, 30)
    button1.css_class 'clear_background'
    button1.css_class 'blightgreen5'
    button1.disallow_resizing

    minimal(button1, 3)
    minimal(text('Next, showing a transparent widget'))
    button4 = gtk_button('Button #4')
    button4.width_height(30, 30)
    button4.css_class 'bgreen5'
    button4.css_class 'transparent'
    button4.disallow_resizing
    minimal(button4, 3)

    button5 = gtk_button('Button #5')
    button5.width_height(30, 30)
    button5.css_class 'bgreen5'
    button5.disallow_resizing
    button5.use_this_font = 'Cantarell Bold 11'
    minimal(button5, 3)
    
    text = text('Yoda Text')
    text.css_class('BG_Black')
    text.css_class('yoda')
    text.pad8px
    text.make_selectable
    minimal(text, 3)

    p {
      selectable_label 'Der Meeresboden ist mit Haifischzähnen übersät weil sie '\
      'aus einer der härtesten biologischen Substanzen besteht.'
    }

  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # We have to either manually run the method called apply_the_css_string()
    # or we will let Gtk::Runner do this for us when .run() is called.
    apply_the_css_string # For now this has to be called manually.
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::HtmlLikeSupport.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::HtmlLikeSupport.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size
    r.automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::HtmlLikeSupport.run
end