#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This example currently does not work. :(
# =========================================================================== #
# require 'gtk_paradise/example/advanced/cell_data_sorting_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

Gtk.gtk_paradise_css_file
r = Gtk.run
r.set_border_width(10)
r.set_size_request(250, 175)
r.increase_font_size

# =========================================================================== #
# === custom_cell_data_func
# =========================================================================== #
def custom_cell_data_func(
    column, renderer, model, iter, data
  )
  # ========================================================================= #
  # Get the color string stored by the column and make it the foreground 
  # color.
  # ========================================================================= #
  text = model.get(iter, COLOR)
  renderer.props.foreground_rgba = Gdk::RGBA.new(red = 1.0, green = 1.0, blue = 1.0, alpha = 1.0)
  red   = (text[1, 3]* 16).to_f / 255
  green = (text[3, 5]* 16).to_f / 255
  blue  = (text[5, 7]* 16).to_f / 255
  renderer.props.background_rgba = Gdk::RGBA.new(red = red, green = green, blue=blue, alpha=1.0)
  renderer.props.text = text
end


COLOR = 0
clr = %w( 00 33 66 99 CC FF )

store = Gtk::ListStore.new(String, String, String)
treeview = Gtk.treeview(store)

for var1 in clr
  for var2 in clr
    for var3 in clr
      color = "#"+var1+var2+var3
      iter = store.append()
      store.set(iter, COLOR, color)
    end
  end
end

renderer = Gtk::CellRendererText.new
column = Gtk::TreeViewColumn.new
column.pack_start(renderer, true)
column.add_attribute(renderer, 'text', COLOR)
column.set_title('Standard Colors')
treeview.append_column(column)
column.set_cell_data_func(
  renderer,
  custom_cell_data_func(column, renderer, store),
  nil
)

treeview.set_model(store)
scrolled_window = Gtk.scrolled_window(treeview) { :automatic }
scrolled_window.add(treeview)
scrolled_window.bblack3
scrolled_window.set_size_request(500, 300)
r.add(scrolled_win)
r << vbox
r.set_title 'Color List'
r.modify_background(:normal, :white)
r.top_left_then_run