#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::AdvancedCssExample
# =========================================================================== #
# require 'gtk_paradise/example/advanced/advanced_css_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class AdvancedCssExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Advanced CSS example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '50% or 800px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 580

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === USE_THESE_CSS_RULES
  # ========================================================================= #
  USE_THESE_CSS_RULES = '
.blightgreen5 { border: 8px solid lightgreen; }
.bblack5      { border: 8px solid black; }
.bgreen5      { border: 8px solid green; }

.yoda {
  color: yellow;
}

.BG_Black {
  background-color: black;
}

.hover1 {
  font-size: 50px;
  background-image: none;
  border: 2px solid black;
}

.hover1:hover {
  transition: 4000ms linear;
  background-color: lightblue;
}

.hover1:focus {
  transition: border 100ms ease-in;
  background-color: royalblue;
}

.slider1 {
  border-style: solid;
  border-width: 2px;
  border-color: #a7a7a7;
  border-radius: 50% 50% 0 50%;
  background-image: linear-gradient(15deg, #ededed, steelblue);
  box-shadow: inset 0 0 0 2px rgba(255,255,255,0.2),
              2px 2px 2px rgba(0,0,0,0.1);
}

.box_shadow1 {
  box-shadow: inset 1px 0 alpha(tomato, 0.10),
              inset 0 1px alpha(tomato, 0.12),
              inset -1px 0 alpha(tomato, 0.15),
              inset 0 -1px alpha(tomato, 0.05);
}

.foobar       label { color: tomato }
.foobar:hover label { text-shadow: none; color: steelblue; }

.foobar:hover
{
  background-image: none;
  border-color: shade(darkgreen, 0.7);
  background-color: shade(lightgreen, 1.10);
}


.background_for_a_fancy_hover_button_effect {
  background: rgb(242,93,9);
  background: linear-gradient(180deg, rgba(242,93,9,1) 0%, rgba(243,255,0,1) 100%);
  margin: 30px;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0,0,0,.5);
}

.background_for_a_fancy_hover_button_effect button {
  background: palevioletred;
  color: black;
  border: 4px solid gold;
  transition: all 600ms ease-in-out;
}

.background_for_a_fancy_hover_button_effect button:hover {
  box-shadow: 0 0 10px steelblue;
  padding: 10px 20px;
  font-size: 150%;
}


'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # Add more CSS next:
    # ======================================================================= #
    more_CSS USE_THESE_CSS_RULES
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(gtk_left_aligned_label('Showcasing CSS-buttons next.'))

    button1 = gtk_button('Button #1')
    button1.width_height(30, 30)
    button1.css_class 'clear_background'
    button1.css_class 'blightgreen5'
    button1.disallow_resizing

    button2 = gtk_button('Button #2')
    button2.width_height(30, 30)
    button2.css_class 'bblack5'
    button2.disallow_resizing

    button3 = gtk_button('Button #3')
    button3.width_height(30, 30)
    button3.css_class 'bgreen5'
    button3.disallow_resizing

    minimal(button1, 3)
    minimal(button2, 3)
    minimal(button3, 3)
    minimal(text('Next, showing a transparent widget'))
    button4 = gtk_button('Button #4')
    button4.width_height(30, 30)
    button4.css_class 'bgreen5'
    button4.css_class 'transparent'
    button4.disallow_resizing
    minimal(button4, 3)

    button5 = gtk_button('Button #5')
    button5.width_height(30, 30)
    button5.css_class 'bgreen5'
    button5.disallow_resizing
    button5.use_this_font = 'Cantarell Bold 11'
    minimal(button5, 3)
    
    # ======================================================================= #
    # === Yoda text:
    # ======================================================================= #
    text = gtk_text(
      'Yoda Text - with hover and focus effect (called .hover1)'
    )
    text.css_class('BG_Black')
    text.css_class('yoda')
    text.pad8px
    text.css_class('hover1')
    text.make_selectable
    minimal(text, 3)

    entry = gtk_entry('This is a test for Gtk::Entry.')
    entry.set_name('hover1')
    minimal(entry, 2)
    
    box = hbox
    box.add(bold_text('This is just some text.'))
    box.css_class('slider1')
    minimal(box, 15)

    box = hbox
    box.add(bold_text('This will show a shadow.'))
    another_button = button('Just an irrelevant button.')
    another_button.on_clicked {
      e 'Yup - it is an irrelevant button.'
    }
    box.add(another_button)
    _ = label('Just an irrelevant label.')
    _.css_class('foobar')
    box.add(_)
    _ = button('And another irrelevant button.')
    _.css_class('foobar')
    box.add(_)
    box.css_class('box_shadow1')
    minimal(box, 25)

    box = hbox
    button_stop = gtk_button('Stop')
    hbox1 = gtk_hbox
    hbox1.css_class('background_for_a_fancy_hover_button_effect')
    hbox1.add(button_stop)
    hbox1.show_all
    button_stop.on_clicked {
      e 'A button was clicked.'
    }
    box.add(hbox1)
    minimal(box, 10)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # ======================================================================= #
    # We have to either manually run the method called apply_the_css_string()
    # or we will let Gtk::Runner do this for us when .run() is called.
    # apply_the_css_string # For now this has to be called manually.
    # ^^^ since as of January 2022 this no longer has to be called manually.
    # ======================================================================= #
    super()
  end

  # ========================================================================= #
  # === Gtk::AdvancedCssExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::AdvancedCssExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::AdvancedCssExample.run
end