#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/advanced_button_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class AdvancedButtonExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Advanced Button example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 800

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 400

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    title_width_height_font(TITLE, WIDTH, HEIGHT, :dejavu_condensed_20)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
    # ======================================================================= #
    # Style the button via ad-hoc CSS rules.
    # ======================================================================= #
    more_css '
.blightgreen { border: 2px solid darkgreen; }
.bblack5     { border: 8px solid black; }
.bgreen5     { border: 8px solid green; }
'
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    6
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(left_aligned_label('Showcasing per-button code.'))

    button1 = button('This is our test-button')
    button1.width_height(50, 50)
    button1.bblack3
    button1.css_class('clear_background')
    button1.css_class('BG_lightgreen')
    button1.disallow_resizing
    button1.hover_colour :mistyrose # Test the prelight effect.
    button1.on_clicked {
      e 'This button was clicked.'
    }
    hbox = create_hbox(button1)
    hbox.set_border_width(4)
    hbox.width_height(120, 120)
    pack_start(hbox, fill: false, expand: false, padding: 5)
    set_border_width(4)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # ======================================================================= #
    # We have to either manually run the method called apply_the_css_string()
    # or we will let Gtk::Runner do this for us when .run() is called.
    # ======================================================================= #
    apply_the_css_string # For now this has to be called manually.
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::AdvancedButtonExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::AdvancedButtonExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::AdvancedButtonExample.run
end