#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/csv_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/run'

r = Gtk.run
r.increase_font_size
hbox = Gtk.vbox
_ = Gtk.read_in_from_this_csv_file(:default, :default, :strip_quotes)
if _.nil?
  e 'Please supply a valid (local) .csv file. Replace the above argument'
  e 'if necessary (the first one, called :default, with the path to the .csv file)'
  exit
end
Gtk.project_css_file
hbox.maximal(_, 10)
hbox.css_class('bblack3')
hbox.show_all
button = Gtk.button('Change colour on right-mouse-button-click event')
button.set_name('BG_gold')
button.css_class('clear_background')
button.bblack2
button.on_right_mouse_button_click_event {
  button.change_colour_to(:darkblue)
  button.transition_change_background_to(:lightgreen, 3)
}

hbox.pack_start(button, expand: true, fill: true, padding: 5)
scrolled_window = Gtk.scrolled_window(hbox) { :always }
r << scrolled_window
r.modify_background(:normal, :white)
r.top_left_then_run
