#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/019_gtk_entry_showing_the_cursor_position.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

alias e puts

r = Gtk.run
r.add_events(:scroll_mask)
r.set_size_request(500, 100)
r.use_this_font(:hack_20)
hbox = Gtk.vbox
Gtk.project_css_file

hbox.pad8px
hbox.show_all

entry1 = Gtk.entry('This is a simple test string.')
entry1.enable_all_events
entry1.signal_connect(:event) {|widget, event|
  name_of_the_event = event.class.to_s
  case name_of_the_event
  # ========================================================================= #
  # === Gdk::EventKey
  # ========================================================================= #
  when 'Gdk::EventKey'
    e 'A key was pressed.'
    if Gtk.is_enter_key?(event)
      e 'It was the enter key!'
    end
  # ========================================================================= #
  # === Gdk::EventButton
  # ========================================================================= #
  when 'Gdk::EventButton'
    if event.name? == 'GDK_BUTTON_RELEASE'
      e 'A mouse-button was clicked. The cursor '\
        'position is at: '+entry1.cursor_position.to_s
    end
  # ========================================================================= #
  # === Gdk::EventScroll
  # ========================================================================= #
  when 'Gdk::EventScroll'
    if ::Gtk.scroll_up_event?(event)
      e 'A scrolling event took place - upwards scroll event.'
    elsif ::Gtk.scroll_down_event?(event)
      e 'A scrolling event took place - downwards scroll event.'
    else
      e 'It was an unknown event.'
    end
  end
}
entry1.clear_background
entry1.bblack1
entry1.pad10px
# entry1.background(:lightblue)
hbox.pack_start(entry1, expand: true, fill: true, padding: 6)

scrolled_window = Gtk.scrolled_window(hbox) { :always }
scrolled_window.width_height(700, 200)
r << scrolled_window
r.modify_background(:normal, :white)
r.top_left_then_run
