#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ScaleThisImage
#
# This example shows how to scale up an image.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/advanced/020_scale_this_image.rb'
# Gtk::ScaleThisImage.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ScaleThisImage < ::Gtk::BaseModuleBox # === Gtk::ScaleThisImage 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Scale This Image'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '55% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    filename =
      File.absolute_path(
        '../../images/internal/directory_content_screenshot.png'
      )
    vbox = gtk_vbox
    original_pixbuf = GdkPixbuf::Pixbuf.new(file: filename)
    image1 = original_pixbuf.scale_simple(180, 180, :hyper) # Gtk::Gdk::INTERP_BILINEAR)
    vbox.minimal(
      ::Gtk::Image.new(pixbuf: image1)
    )
    image2 = original_pixbuf.scale(840, 440, :nearest)
    vbox.add(::Gtk::Image.new(pixbuf: image2))

    scrolled_window = gtk_scrolled_window(vbox)
    maximal(scrolled_window)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::ScaleThisImage.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ScaleThisImage.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ScaleThisImage.run
end