#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::StatusBarExample
# =========================================================================== #
# require 'gtk_paradise//gtk3/025_image_in_label_example.rb'
# Gtk::StatusBarExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class StatusBarExample < ::Gtk::BaseModuleBox # === Gtk::StatusBarExample 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Showing a gold caret on black background'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '75% or minimum 800px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    more_CSS '
    * {
      caret-color: gold;
    }
    '
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    @entry1 = entry
    @entry1.css_class('lightblue')
    @entry1.set_text('Testing ...')
    @entry1.pad8px
    @entry1.use_this_font = :hack_25
    @entry1.hcenter
    @entry1.width_height(800, 100)
    minimal(@entry1)
    @status_bar = gtk_status_bar('generic_id')
    @status_bar.push_message('HEY MSG')
    minimal(@status_bar)
  end

  # ========================================================================= #
  # === status_bar?
  # ========================================================================= #
  def status_bar?
    @status_bar
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    Thread.new {
      sleep 0.0005
      @entry1.do_focus
      @entry1.deselect
      @entry1.cursor_is_on_the_end
    }
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::StatusBarExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::StatusBarExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::StatusBarExample.run
end