#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::CustomizedFrameExample
#
# This examples shows how you can modify a Gtk::Frame to accept custom
# widgets.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/gtk3_standalone/gtk3_standalone.rb'
# Gtk::CustomizedFrameExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class CustomizedFrameExample < ::Gtk::BaseModuleFrame # === Gtk::CustomizedFrameExample 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Customized Frame Example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '15% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    6
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    4
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    self.label_widget = return_styled_frame
  end

  # ========================================================================= #
  # === return_styled_frame
  #
  # This method will return the styled frame.
  # ========================================================================= #
  def return_styled_frame
    hbox = create_hbox
    hbox.minimal(
      button('1').tap { |widget|
        widget.hint = 'The first button.'
        widget.bblack1
      },       5
    )
    hbox.minimal(
      button('2').tap { |widget|
        widget.hint = 'The second button.'
        widget.bsteelblue1
      },  10
    )
    hbox.minimal( # This one is coloured.
      button('3').tap { |widget|
        widget.hint = 'The third button.'
        widget.blightgreen1
      }, 15
    )
    hbox.minimal(
      button('4').tap { |widget| widget.bnavy1 },       10
    )
    hbox.minimal(
      button('5').tap { |widget| widget.bdarkorchid1 },  5
    )
    return hbox
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::CustomizedFrameExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = Gtk::CustomizedFrameExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::CustomizedFrameExample.run
end