#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::EntryCompletionExample
#
# This example shows how to scale up an image.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/advanced/020_scale_this_image.rb'
# Gtk::EntryCompletionExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class EntryCompletionExample < ::Gtk::BaseModuleBox # === Gtk::EntryCompletionExample 

  begin
    require 'studium/toplevel_methods/toplevel_methods.rb'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Scale This Image'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '55% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    12
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    8
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    vbox = create_vbox
    vbox.left_aligned_text('This shows an example how to use a completable entry.')
    entry = create_entry
    array = []
    array << %w( andy andrew john joe fox cat dog dave )
    array << Studium.available_exam_topics_in_short_form? if Object.const_defined?(:Studium)
    entry.completion = create_entry_completion(array)
    vbox.minimal(entry, 25)
    scrolled_window = create_scrolled_window(vbox)
    maximal(scrolled_window)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::EntryCompletionExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::EntryCompletionExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::EntryCompletionExample.run
end