#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ComboBoxExample
#
# This class should ideally showcase everything a ComboBoxText can do.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/advanced/020_scale_this_image.rb'
# Gtk::ComboBoxExample.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ComboBoxExample < ::Gtk::BaseModuleBox # === Gtk::ComboBoxExample 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Combo Box Example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '55% or minimum 100px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    12
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    8
  end

  # ========================================================================= #
  # === let_the_combo_box_respond_to_on_changed_events
  # ========================================================================= #
  def let_the_combo_box_respond_to_on_changed_events
    @combo_box_text.on_changed {
      e tomato(@combo_box_text.active_text?)
    }
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    vbox = create_vbox
    vbox.left_aligned_text(
      'This shows an example how to use a completable entry.'
    )
    array = %w( cat mouse dog )
    @combo_box_text = ::Gtk::ComboBoxText.new
    pp array
    @combo_box_text.fill_up(array)
    @combo_box_text.set_active(0)
    # list_store = @combo_box_text.list_store?
    let_the_combo_box_respond_to_on_changed_events
    # iter_child = list_store.iter_first
    # e 'The list-store is:'
    # pp list_store
    # pp all_methods?
    vbox.minimal(combo_box_text, 25)
    scrolled_window = create_scrolled_window(vbox)
    maximal(scrolled_window)
  end

  # ========================================================================= #
  # === combo_box_text?
  # ========================================================================= #
  def combo_box_text?
    @combo_box_text
  end; alias _ combo_box_text? # === _

  # ========================================================================= #
  # === all_methods?
  # ========================================================================= #
  def all_methods?
    @combo_box_text.methods.sort
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::ComboBoxExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ComboBoxExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ComboBoxExample.run
end