#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is currently unfinished; eventually we will pack all examples
# into this widget.
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

BASE_DIR = Gtk.project_base_directory?

target = BASE_DIR+'examples/gtk3/'

all_files = Dir[
  target+'*.rb'
]
all_files << Dir[
  BASE_DIR+'examples/advanced/*.rb'
]
all_files.flatten!
# =========================================================================== #
# Designate which files are to be packed:
# =========================================================================== #
display_these_files = all_files.select {|entry|
  case entry
  when /small_paned_example/,
       /password_example/,
       /progress_bar_example/,
       /paned_widget_example/,
       /icon_theme_example/,
       /switcher_window/,
       /list_box_example/,
       /hello_world_in_gtk3_and_bold_font/,
       /buttons_showcasing_the_relief/,
       /text_buffer_example/,
       /radio_button_window/,
       /scale_button_demo/,
       /hover_button_example_via_css/,
       /spin_button_example/,
       /search_bar_example/,
       /spinner_example/
    true
  else
    false
  end
}

# =========================================================================== #
# This example only works on ruby-gtk3, as Gtk::Switch is not part of gtk2.
# =========================================================================== #
pp display_these_files

display_these_files.each {|this_file|
  puts "Now requiring this file: #{this_file}"
  require this_file
}

window = Gtk::Window.new
window.set_size_request(1300, 500)

notebook = Gtk::Notebook.new
notebook.set_scrollable(true)
notebook.set_show_tabs(true)
notebook.set_tab_pos(:left) # or :top
notebook.append_page(Gtk::PasswordExample.new,            Gtk::Label.new(' (1) Gtk::PasswordExample'))
notebook.append_page(Gtk::ProgressBarWindow.new,          Gtk::Label.new(' (2) Gtk::ProgressBarWindow'))
notebook.append_page(Gtk::PanedWidgetExample.new,         Gtk::Label.new(' (3) Gtk::PanedWidgetExample'))
notebook.append_page(Gtk::IconThemeExample.new,           Gtk::Label.new(' (4) Gtk::IconThemeExample'))
notebook.append_page(Gtk::SwitcherWindow.new,             Gtk::Label.new(' (5) Gtk::SwitcherWindow'))
notebook.append_page(Gtk::ListBoxExample.new,             Gtk::Label.new(' (6) Gtk::ListBoxExample'))
notebook.append_page(Gtk::HelloWorld.new,                 Gtk::Label.new(' (7) Gtk::HelloWorld'))
notebook.append_page(Gtk::ButtonsShowcasingTheRelief.new, Gtk::Label.new(' (8) Gtk::ButtonsShowcasingTheRelief'))
notebook.append_page(Gtk::TextBufferExample.new,          Gtk::Label.new(' (9) Gtk::TextBufferExample'))
notebook.append_page(Gtk::RadioButtonWindow.new,          Gtk::Label.new('(10) Gtk::RadioButtonWindow'))
notebook.append_page(Gtk::ScaleButtonDemo.new,            Gtk::Label.new('(11) Gtk::ScaleButtonDemo'))
notebook.append_page(Gtk::HoverButtonExampleViaCss.new,   Gtk::Label.new('(12) Gtk::HoverButtonExampleViaCss'))
notebook.append_page(Gtk::SpinButtonExample.new,          Gtk::Label.new('(13) Gtk::SpinButtonExample'))
notebook.append_page(Gtk::SmallPanedExample.new,          Gtk::Label.new('(14) Gtk::SmallPanedExample'))
notebook.append_page(Gtk::SpinnerExample.new,             Gtk::Label.new('(15) Gtk::SpinnerExample'))
notebook.append_page(Gtk::SearchBarExample.new,           Gtk::Label.new('(16) Gtk::SearchBarExample'))

notebook.show_all
window.add(notebook)
window.show_all
window.move(0, 0)
Gtk.main