#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class BorderExamples < ::Gtk::ScrolledWindow

  include Gtk::BaseModule

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :hack_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    set_use_this_font(USE_THIS_FONT)
    add_gtk_paradise_project_css_file
    random_html_colour1 = random_html_colour
    random_html_colour2 = random_html_colour
    random_html_colour3 = random_html_colour
    random_html_colour4 = random_html_colour
    random_html_colour5 = random_html_colour
    random_html_colour6 = random_html_colour
    more_CSS_then_apply_it '

.border1 {
  border-bottom: 3px solid darkblue;
}

.border2 {
  border-right:  8px ridge crimson;
  border-left:  18px solid tomato;
}

.border3 {
  border:  25px dotted lightgreen;
  border-radius:  16px;
}

.border4 {
  border:  25px solid violet;
  border-radius:  16px;
}

.border5 {
  border:  25px inset '+random_html_colour1+';
  border-radius:  16px;
}

.border6 {
  border:  25px outset '+random_html_colour2+';
  border-radius:  16px;
}

.border7 {
  border:  22px dashed '+random_html_colour3+';
  border-radius:  16px;
}

.border8 {
  border:  25px double '+random_html_colour4+';
  border-radius:  16px;
}

.border9 {
  border:  25px groove '+random_html_colour5+';
  border-radius:  16px;
}

.border10 {
  border:  25px ridge '+random_html_colour6+';
  border-radius:  16px;
}

.border11 {
  border:  25px solid '+random_html_colour6+';
  border-radius:  16px;
  box-shadow:inset rgba(15,55,123, .8) 1.5em .2em 5em;
}

.border12 {
  border: 12px solid steelblue;
  border-radius: 25px;
}

    '
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @outer_vbox = gtk_vbox
    @outer_vbox.add(
      gtk_text('Border examples via CSS')
    )

    # ======================================================================= #
    # === hbox_border1
    # ======================================================================= #
    hbox_border1 = gtk_hbox
    hbox_border1.css_class('border1')
    hbox_border1.pad8px
    hbox_border1.add(
      selectable_text('This is inside of a box with border-bottom: 3px solid darkblue.')
    )
    @outer_vbox.minimal(hbox_border1, 10)

    # ======================================================================= #
    # === hbox_border2
    # ======================================================================= #
    hbox_border2 = gtk_hbox
    hbox_border2.css_class('border2')
    hbox_border2.pad8px
    hbox_border2.add(
      text('This one makes use of differential side borders.')
    )
    @outer_vbox.minimal(hbox_border2, 10)
    
    # ======================================================================= #
    # === hbox_border3
    # ======================================================================= #
    hbox_border3 = gtk_hbox
    hbox_border3.css_class('border3')
    hbox_border3.pad8px
    hbox_border3.add(
      text('This one shows a rounded border.')
    )
    @outer_vbox.minimal(hbox_border3, 10)

    # ======================================================================= #
    # === hbox_border4
    # ======================================================================= #
    hbox_border4 = gtk_hbox
    hbox_border4.css_class('border4')
    hbox_border4.pad8px
    hbox_border4.add(
      text('As above but with a solid border.')
    )
    @outer_vbox.minimal(hbox_border4, 10)

    # ======================================================================= #
    # === hbox_border5
    # ======================================================================= #
    hbox_border5 = gtk_hbox
    hbox_border5.css_class('border5')
    hbox_border5.pad8px
    hbox_border5.add(
      text('As above but with an inset border.')
    )
    @outer_vbox.minimal(hbox_border5, 10)

    # ======================================================================= #
    # === hbox_border6
    # ======================================================================= #
    hbox_border6 = gtk_hbox
    hbox_border6.css_class('border6')
    hbox_border6.pad8px
    hbox_border6.add(
      text('As above but with an outset border.')
    )
    @outer_vbox.minimal(hbox_border6, 10)

    # ======================================================================= #
    # === hbox_border7
    # ======================================================================= #
    hbox_border7 = gtk_hbox
    hbox_border7 = gtk_hbox
    hbox_border7.css_class('border7')
    hbox_border7.pad8px
    hbox_border7.add(
      text('As above but with a dashed border.')
    )
    @outer_vbox.minimal(hbox_border7, 10)

    # ======================================================================= #
    # === hbox_border8
    # ======================================================================= #
    hbox_border8 = gtk_hbox
    hbox_border8.css_class('border8')
    hbox_border8.pad8px
    hbox_border8.add(
      text('As above but with a double border.')
    )
    @outer_vbox.minimal(hbox_border8, 10)

    # ======================================================================= #
    # === hbox_border9
    # ======================================================================= #
    hbox_border9 = gtk_hbox
    hbox_border9.css_class('border9')
    hbox_border9.pad8px
    hbox_border9.add(
      text('As above but with a groove border.')
    )
    @outer_vbox.minimal(hbox_border9, 10)
    
    # ======================================================================= #
    # === hbox_border10
    # ======================================================================= #
    hbox_border10 = gtk_hbox
    hbox_border10.css_class('border10')
    hbox_border10.pad8px
    hbox_border10.add(
      text('As above but with a ridge border.')
    )
    @outer_vbox.minimal(hbox_border10, 10)

    # ======================================================================= #
    # === hbox_border11
    # ======================================================================= #
    hbox_border11 = gtk_hbox
    hbox_border11.css_class('border11')
    hbox_border11.pad8px
    hbox_border11.add(
      text('This one also shows a shadow.')
    )
    @outer_vbox.minimal(hbox_border11, 10)

    # ======================================================================= #
    # === hbox_border12
    # ======================================================================= #
    hbox_border12 = gtk_hbox
    hbox_border12.css_class('border12')
    hbox_border12.pad8px
    hbox_border12.add(
      text('This one shows a rounded border.')
    )
    @outer_vbox.minimal(hbox_border12, 10)

    add(@outer_vbox)
    set_size_request(1400, 900)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  _ = Gtk::BorderExamples.new
  r = Gtk.runner
  r.title = 'Showcasing CSS borders in GTK'
  r << _
  r.padding 18
  r.top_left_then_run
end