#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ImportCSSFile < ::Gtk::ScrolledWindow

  include Gtk::BaseModule

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :hack_16

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    set_use_this_font(USE_THIS_FONT)
    # random_html_colour1 = random_html_colour
    # ======================================================================= #
    # Next load the colours.css file via an @import statement:
    # ======================================================================= #
    more_CSS_then_apply_it '

@import url("'+Gtk.project_base_directory?+'css_files/colours.css");

.fancy_border {
  border:  15px inset orange;
  border-radius:  16px;
}
'
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @outer_vbox = gtk_vbox
    @outer_vbox.add(
      gtk_text('CSS import statement example')
    )

    # ======================================================================= #
    # === sample_widget
    # ======================================================================= #
    sample_widget = gtk_hbox
    sample_widget.css_class('pad8px')
    sample_widget.css_class('crimson')
    sample_widget.css_class('fancy_border')
    text = left_aligned_text(
      "This text will appear in crimson colour if a certain .css file "\
      "has been found.\n\nSo if you see this in a ~reddish colour then "\
      "that step has worked properly.\n\nThe CSS code in use will tap "\
      "into <b>@import url()</b>.\n\nThe code to the CSS in use for "\
      "this widget is shown below this box."
    )
    sample_widget.add(text)
    sample_widget.set_border_width(15)
    @outer_vbox.minimal(sample_widget, 10)
    scrolled_widget = return_scrollable_CSS_in_use_widget
    scrolled_widget.use_this_font = :dejavu_15
    @outer_vbox.minimal(scrolled_widget, 25)
    add(@outer_vbox)
    set_size_request(1600, 900)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  _ = Gtk::ImportCSSFile.new
  r = Gtk.run(title: 'Importing .css files example')
  r << _
  r.apply_the_internal_title
  r.top_left_then_run
end