#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/drawing/drawing.rb'

include Math

L = 500

# =========================================================================== #
# === RADIUS_TO_USE
# =========================================================================== #
RADIUS_TO_USE = 25

Drawing.app(width: L, height: L) {
  draw { clear }

  quit_window = proc { 
    make_window { |window|
      set_title('')
      add(
        button {
          set_size_request(120, 40)
          text = ::Gtk::Label.new.set_markup('<span size="x-large">Quit!</span>')
          add(text)
          signal_connect(:clicked) { ::Gtk.main_quit }
        }
      )
    }
  }
  
  mouse_button { |w, e|
    quit_window.call if e.button != 1
    # ======================================================================= #
    # Find some random RGB colours next:
    # ======================================================================= #
    color(
      rand(65536), rand(65536), rand(65536)
    )
    arc(
      true,
      e.x - RADIUS_TO_USE,
      e.y - RADIUS_TO_USE,
      RADIUS_TO_USE * 2,
      RADIUS_TO_USE * 2,
      0,
      64 * 360
    ) 
  }
}