#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require '001_gdk_screen_properties.rb'
# =========================================================================== #
require 'gtk3'

alias e puts

e
e 'This example shows methods related to Gdk::Screen.default().'
e

@screen = Gdk::Screen.default

settings_map = %w(
  gtk-double-click-time
  gtk-dnd-drag-threshold
  gtk-can-change-accels
  gtk-color-palette
  gtk-font-name
  gtk-icon-sizes
  gtk-key-theme-name
  gtk-toolbar-style
  gtk-toolbar-icon-size
  gtk-im-preedit-style
  gtk-im-status-style
  gtk-cursor-blink
  gtk-cursor-blink-time
  gtk-theme-name 
)

e 'The available methods are:'
e
pp @screen.methods.sort
e

settings_map.each { |entry|
  e "#{entry}: #{@screen.get_setting(entry)}"
  pp @screen.get_setting(entry)
}

e 'The current desktop is: '+
  @screen.current_desktop.to_s

pp @screen.destroyed?

# pp @screen.get_monitor_geometry

e 'The name of the window manager is: '+
  @screen.window_manager_name
e '.rgba_visual:'
pp @screen.rgba_visual
e '.root_window:'
pp @screen.root_window # #<Gdk::X11Window:0x555e15c2f790 ptr=0x555e13849200>
e '.screen_number:'
pp @screen.screen_number
