#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# Based on the 'Hello world' Gtk+ tutorial example at
#
#   https://library.gnome.org/devel/gtk-tutorial/2.90/x344.html
#
# =========================================================================== #
require 'gtk_paradise/require_gtk2.rb'

callback = lambda { |_widget, data|
  puts "Hello again - #{data} was pressed"
}

win = Gtk::Window.new(:toplevel)
win.title = 'Hello Buttons!'

win.signal_connect('delete-event') {
  Gtk.main_quit
  false
}

win.border_width = 10

# box = Gtk::HBox.new(false, 0)
box = Gtk::HBox.new
win.add(box)

button = Gtk::Button.new_with_label('Button 1')
button.signal_connect('clicked', "button 1", &callback)
box.pack_start button, true, true, 0
button.show

button = Gtk::Button.new_with_label('Button 2')
button.signal_connect('clicked', "button 2", &callback)
box.pack_start button, true, true, 0
button.show

box.show
win.show
Gtk.main