#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/examples/gtk2/list_store_example.rb'
# =========================================================================== #
require 'gtk2'

class ListStoreExample

  alias e puts

  # ========================================================================= #
  # === DATASTRUCTURE
  # ========================================================================= #
  DATASTRUCTURE = [
    ['Hello', 'KON-NI-CHIWA'],
    ['Goodbye', 'SAYO-NARA'],
    ['Good morning', 'OHA-YO-GOZAI-MASU'],
    ['Good evening', 'KON-BAN-WA'],
    ['waaa', 'aaa'],
  ]

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    reset
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    @handle_box = Gtk::HandleBox.new
  end

  # ========================================================================= #
  # === create_the_main_window
  # ========================================================================= #
  def create_the_main_window
    @window = Gtk::Window.new
    @window.show_all
    @window.title = 'ListStore'
    @window.signal_connect(:destroy) { Gtk.main_quit }
    @window.set_default_size(1500, 800)
    @window.move(0, 0)
  end
  
  # ========================================================================= #
  # === h_box
  # ========================================================================= #
  def h_box
    @h_box = Gtk::HBox.new(false, 0)
  end

  # ========================================================================= #
  # === create_buttons
  # ========================================================================= #
  def create_buttons
    @button_quit  = Gtk::Button.new('_Quit')
    @button_quit.signal_connect(:clicked) { Gtk.main_quit }
    @button_clear = Gtk::Button.new('_Clear')
    @button_clear.signal_connect(:clicked) { @list_store.clear }
    # This button adds new elements.
    @button_add_new = Gtk::Button.new('_AddNew')
    @button_add_new.signal_connect(:clicked) {  
      e 'Adding new Datastructure again.'
      add_datastructure
    }
  end
  
  # ========================================================================= #
  # === make_list_store
  # ========================================================================= #
  def make_list_store
    @list_store = Gtk::ListStore.new(String, String)
    @tree_view = Gtk::TreeView.new(@list_store)
    column1 = Gtk::TreeViewColumn.new('Data', Gtk::CellRendererText.new, { text: 0 })
    column2 = Gtk::TreeViewColumn.new('Year',  Gtk::CellRendererText.new, { text: 1 })
    @tree_view.append_column(column1)
    @tree_view.append_column(column2)
    add_datastructure
    @tree_view.enable_model_drag_source(Gdk::Window::BUTTON1_MASK,
      [ ['GTK_TREE_MODEL_ROW', 0, 0] ], 
      Gdk::DragContext::ACTION_COPY|Gdk::DragContext::ACTION_MOVE
    )
    @tree_view.enable_model_drag_dest(
      [ ['GTK_TREE_MODEL_ROW', 0, 0] ],
      Gdk::DragContext::ACTION_COPY|Gdk::DragContext::ACTION_MOVE
    ) 
  end

  # =================================================================== #
  # === add_datastructure
  #
  # This will again append to the list-store object.
  # =================================================================== #
  def add_datastructure
    DATASTRUCTURE.each { |v1, v2|
      iter = @list_store.append
      iter.set_value(0, v1)
      iter.set_value(1, v2)
    }
  end

  # =================================================================== #
  # === connect_skeleton
  # =================================================================== #
  def connect_skeleton
    vbox = Gtk::VBox.new
    vbox.add(@button_clear).
         add(@button_add_new).
         add(@button_quit)
    @h_box.add(@tree_view).
           add(vbox)
    # ================================================================= #
    # Modify the handle_box next:
    # ================================================================= #
    @handle_box.set_handle_position(Gtk::POS_RIGHT)
    @handle_box.snap_edge = 1
    @window.add(
      @handle_box.add(@h_box)
    )
    @window.show_all
    Gtk.main
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    create_the_main_window
    h_box
    create_buttons
    make_list_store
    connect_skeleton
  end
  
end

if __FILE__ == $PROGRAM_NAME
  ListStoreExample.new # $RUBY_GTK/list_store.rb  
end