#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This is a popup example, that is, when you click the right mouse button,
# a context-menu will emerge.
# =========================================================================== #
require 'gtk2'

context_menu = Gtk::Menu.new
context_menu.append(mitem1 = Gtk::MenuItem.new('Test1'))
context_menu.append(mitem2 = Gtk::MenuItem.new('Test2'))
context_menu.append(mitem3 = Gtk::MenuItem.new('Test3'))
context_menu.append(mitem4 = Gtk::MenuItem.new('Test4'))
context_menu.append(mitem5 = Gtk::MenuItem.new('Test5'))
context_menu.show_all

# =========================================================================== #
# Next, let these menu-items respond to when the user activates them.
# =========================================================================== #
mitem1.signal_connect(:activate) { |widget| puts "#{widget.class} - Test1" }
mitem2.signal_connect(:activate) { |widget| puts "#{widget.class} - Test2" }
mitem3.signal_connect(:activate) { |widget| puts "#{widget.class} - Test3" }
mitem4.signal_connect(:activate) { |widget| puts "#{widget.class} - Test4" }
mitem5.signal_connect(:activate) { |widget| puts "#{widget.class} - Test5" }

window = Gtk::Window.new('A simple example-context-menu')
# =========================================================================== #
# Make window sensitive to Right-mouse-click, to open the pop-up menu.
# window.add_events(:button_press_mask) # ← this is the variant for ruby-gtk3
# =========================================================================== #
window.add_events(Gdk::Event::BUTTON_PRESS_MASK) # in gtk-paradise this becomes: add_button_press_events
window.signal_connect(:button_press_event) { |widget, event|
  # ========================================================================= #
  # Note that 'menu' was defined above, as an instance of Gtk::Menu.
  # ========================================================================= #
  context_menu.popup(nil, nil, event.button, event.time) if (event.button == 3) # right mouse click event.
}
# =========================================================================== #
# Make this window sensitive to <Shift+F10> accelerator keys.
# These accelerator keys generate the 'popup-menu' signal for
# the window, which opens the popup-menu.
# =========================================================================== #
window.signal_connect(:popup_menu) { |widget|
  # context_menu.popup(nil, nil, 0, Gdk::CURRENT_TIME)
  puts 'shift+F10 was pressed' # This will ONLY show up via shift+F10, and not via right-mouse button click event.
  context_menu.popup(nil, nil, 0, Gdk::Event::CURRENT_TIME)
}

window.set_default_size(400, 200).show_all
window.signal_connect(:destroy) { Gtk.main_quit }
label_widget = Gtk::Label.new(
  "Hello World\nYou may 'right-click' me\n\n or use <Shift+F10>"
)

hbox = Gtk::HBox.new
hbox.add(label_widget)
window.add(hbox)
window.show_all
window.move(0, 0)
Gtk.main