#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This will create a link-button.
# =========================================================================== #
require 'gtk2'

window = Gtk::Window.new('Gtk::LinkButton example')
window.signal_connect(:destroy) { Gtk.main_quit }
window.move(0, 0)
window.set_size_request(800, 800)

vbox = Gtk::VBox.new

# =========================================================================== #
# URI only
# =========================================================================== #
button1 = Gtk::LinkButton.new('https://ruby-gnome2.osdn.jp/')
button1.signal_connect(:clicked) {
  puts button1.uri
}
vbox.pack_start(button1)

# =========================================================================== #
# URI with a label
# =========================================================================== #
button2 = Gtk::LinkButton.new('https://ruby-gnome2.osdn.jp/',
			      'Ruby-GNOME2 Website')
button2.signal_connect(:clicked) {
  puts button2.uri
}

# =========================================================================== #
# Global setting instead of using clicked signals.
# =========================================================================== #
Gtk::LinkButton.set_uri_hook {|button, link|
  puts "set_uri_hook: " + link
}

vbox.pack_start(button2)
window.add(vbox)
window.show_all
Gtk.main