#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# The code in this file just shows how to make use of Gdk::GC for drawing
# shapes.
# =========================================================================== #
require 'gtk2'

main_window = Gtk::Window.new('Gdk::GC sample')
main_window.set_default_size(500, 500)
main_window.app_paintable = true
main_window.realize

drawable = main_window.window      
gc = Gdk::GC.new(drawable)          

red   = Gdk::Color.new(65535, 0, 0)
green = Gdk::Color.new(0, 65535, 0)

colormap = Gdk::Colormap.system
colormap.alloc_color(red,   false, true)
colormap.alloc_color(green, false, true)

main_window.add(Gtk::Button.new('Test'))
main_window.signal_connect(:expose_event) { |win, evt|
  gc.set_foreground(red)
  gc.set_background(green)

  gc.set_line_attributes(5, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 10, 150, 10)

  gc.set_line_attributes(5, Gdk::GC::LINE_ON_OFF_DASH, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 30, 150, 30)
  
  gc.set_line_attributes(5, Gdk::GC::LINE_DOUBLE_DASH, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 50, 150, 50)
  
  gc.set_line_attributes(30, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 100, 120, 100)
  
  gc.set_line_attributes(30, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_BUTT, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 140, 120, 140)
  
  gc.set_line_attributes(30, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_ROUND, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 180, 120, 180)
  
  gc.set_line_attributes(30, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_PROJECTING, Gdk::GC::JOIN_MITER)
  drawable.draw_line(gc, 20, 220, 120, 220)
  
  gc.set_line_attributes(40, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_MITER)
  drawable.draw_lines(gc, [[200, 80], [220, 30], [280, 50]])

  gc.set_line_attributes(40, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_ROUND)
  drawable.draw_lines(gc, [[200, 170], [220, 120], [280, 140]])
  
  gc.set_line_attributes(40, Gdk::GC::LINE_SOLID, Gdk::GC::CAP_NOT_LAST, Gdk::GC::JOIN_BEVEL)
  drawable.draw_lines(gc, [[200, 260], [220, 210], [280, 230]])
}
main_window.show_all.signal_connect(:destroy) { Gtk.main_quit }
main_window.move(0, 0)
Gtk.main
# rb gc_drawing_examples.rb