#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

module Gtk

class HelloWorld < ::Gtk::Window

  alias e puts

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = 'Sans Bold 25'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super('First example')
    set_size_request(400, 400)
    set_border_width(10)
    # set_icon_from_file('/Depot/j/foo.png') # <- You could specify a fav-icon too.
    run if run_already
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    button = ::Gtk::Button.new('Say hello')
    button.signal_connect(:clicked) { |_widget|
      e 'Hello World!! \\o/'
    }
    button.modify_font(
      Pango::FontDescription.new(USE_THIS_FONT)
    )
    add(button)
    signal_connect(:delete_event) { |_widget| ::Gtk.main_quit }
    show_all
    move(0, 0)
    ::Gtk.main
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::HelloWorld.new
end