#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

alias e puts

$stdout.sync = true # why is this needed? could be to continue.
pixbuf_simple_anim = GdkPixbuf::PixbufSimpleAnim.new(64, 64, 24)
array_store_pixels = []
e 'Generating frames, from red: 0 up to 1256'
(0 .. 1256).each {|red|
  array_calc = (
    [ 4*(63-red).abs, 0, 0 ] * (64*64)
  )
  pixels = array_calc.pack('C*')
  array_store_pixels << pixels
  pixbuf = GdkPixbuf::Pixbuf.new(
    data: pixels,
    colorspace: GdkPixbuf::Colorspace::RGB,
    has_alpha: false,
    bits_per_sample: 8,
    width:  64,
    height: 64
  )
  pixbuf_simple_anim.add_frame(pixbuf)
  print '.'
}
e '!done!'
window = Gtk::Window.new
image = Gtk::Image.new(pixbuf_simple_anim)
window.add(image)
window.show_all
window.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main # $RUBY_GTK/simple_pixbuf_animation.rb