#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

window = Gtk::Window.new('buttons - .hide() and .show()')

window.border_width = 2
box1 = Gtk::VBox.new(false, 0)
window.add(box1)
@main_table = Gtk::Table.new(3, 3, false)
@main_table.set_row_spacings(5)
@main_table.set_column_spacings(5)
@main_table.set_border_width(10)
box1.pack_start(@main_table, true, true, 0)
button = []
0.upto(8) { |i|
  button.push Gtk::Button.new('button'+(i+1).to_s)
}
0.upto(8) { |i|
  button[i].signal_connect(:clicked) { |w|
    p [i]
    j = (i + 1) % 9
    if button[j].visible?
      button[j].hide # hide or show 'em!
    else
      button[j].show # Show them again.
    end
  }
  button[i].can_focus = false
  button[i].show  
}
@main_table.attach(button[0], 0, 1, 0, 1, nil, nil, 0, 0)
@main_table.attach(button[1], 1, 2, 1, 2, nil, nil, 0, 0)
@main_table.attach(button[2], 2, 3, 2, 3, nil, nil, 0, 0)
@main_table.attach(button[3], 0, 1, 2, 3, nil, nil, 0, 0)
@main_table.attach(button[4], 2, 3, 0, 1, nil, nil, 0, 0)
@main_table.attach(button[5], 1, 2, 2, 3, nil, nil, 0, 0)
@main_table.attach(button[6], 1, 2, 0, 1, nil, nil, 0, 0)
@main_table.attach(button[7], 2, 3, 1, 2, nil, nil, 0, 0)
@main_table.attach(button[8], 0, 1, 1, 2, nil, nil, 0, 0)
separator = Gtk::HSeparator.new
box1.pack_start(separator, false, true, 0)
box2 = Gtk::VBox.new(false, 10)
box2.border_width = 10
box1.pack_start(box2, false, true, 0)
close = Gtk::Button.new('close')
close.signal_connect(:clicked) { Gtk.main_quit }
close.can_focus = false
box2.pack_start(close, true, true, 0)
close.can_default = true
close.grab_default
window.show_all
Gtk.main # $RUBY_GTK/button.rb