#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This will show a colour-choose button.
# =========================================================================== #
require 'gtk2'

window = Gtk::Window.new
window.set_size_request(300, 200)

button = Gtk::ColorButton.new
button.set_color(Gdk::Color.parse('lightgreen'))
button.set_title('Select a Colour!')
button.signal_connect(:color_set) {
  puts "The chosen colour was: #{button.color}"
}


label = Gtk::Label.new('Look at my colour!')

hbox = Gtk::HBox.new
hbox.pack_start(button, expand: false, fill: false, padding: 5)
hbox.pack_start(label,  expand: false, fill: false, padding: 5)

window.add(hbox)
window.show_all
window.signal_connect(:destroy) { Gtk.main_quit }
window.move(0, 0)
Gtk.main