#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk2'

expander = Gtk::Expander.new('Expander Sample')
expander.expanded = true

button = Gtk::Button.new('Hide this button.')
button.signal_connect(:clicked) {
  expander.expanded = false # If the button si clicked, gtk-expander will hide it again.
}

button.set_size_request(300, 300)
expander.add(button)

windows = Gtk::Window.new
windows.add(expander)
windows.show_all
windows.move(0, 0)
windows.signal_connect(:destroy) { Gtk.main_quit }
Gtk.main