#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NotebookExample
#
# This shall demonstrate a simple gtk-notebook.
#
# Note that this example is currently unfinished.
# =========================================================================== #
require 'gtk2'

module Gtk

class NotebookExample < ::Gtk::Notebook

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super()
    reset
    # ======================================================================= #
    # Position the tabs on top. We could also position them on the left-hand
    # side, via Gtk::POS_LEFT for instance. 
    # ======================================================================= #
    set_tab_pos(::Gtk::POS_TOP)
    set_scrollable(true)
    set_show_tabs(true)
    button1 = ::Gtk::Button.new('Button #1')
    append_page(
      button1,
      ::Gtk::Label.new('Tab 1')
    )
    button2 = ::Gtk::Button.new('Button #2')
    append_page(
      button2,
      ::Gtk::Label.new('Tab 2')
    )
    button3 = ::Gtk::Button.new('Button #3')
    append_page(
      button3,
      ::Gtk::Label.new('Tab 3')
    )

    # ======================================================================= #
    # Pass in "true", to denote that these tabs have to be re-orderable.
    # ======================================================================= #
    set_tab_reorderable(button1, true)
    set_tab_reorderable(button2, true)
    set_tab_reorderable(button3, true)

    set_show_border(true)
    set_size_request(800, 600)
    set_tab_border(10)
    set_border_width(10)
    set_tab_hborder(10)
    set_tab_vborder(10)
    self.enable_popup = true
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    Gtk::Settings.default.gtk_font_name = 'Sans 20'
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    self.enable_popup = true
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  window.move(0, 0)
  window.set_size_request(1200, 800)
  notebook_example = Gtk::NotebookExample.new
  window.add(notebook_example)
  window.show_all
  Gtk.main
end